/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.connectors.soap.http.util;

import uk.gov.hmrc.aspire.lts.connectors.soap.http.util.SoapVersionEnum;

public final class SoapUtils {
    public static final String NAMESPACE_SOAP_11 = "http://schemas.xmlsoap.org/soap/envelope";
    public static final String NAMESPACE_SOAP_12 = "http://www.w3.org/2003/05/soap-envelope";
    public static final String ELEMENT_SOAP_ENVELOPE = "Envelope";
    public static final String ELEMENT_SOAP_HEADER = "Header";
    public static final String ELEMENT_SOAP_BODY = "Body";
    public static final String UTF_8 = "UTF-8";

    public static final boolean namespacesMatch(String expectedNS, String receivedNS) {
        if (expectedNS == null || receivedNS == null) {
            return false;
        }
        return expectedNS.equals(receivedNS) || (expectedNS + "/").equals(receivedNS);
    }

    public static final SoapVersionEnum deduceSoapVersion(String namespaceURI) {
        if (SoapUtils.namespacesMatch(NAMESPACE_SOAP_12, namespaceURI)) {
            return SoapVersionEnum.V12;
        }
        if (SoapUtils.namespacesMatch(NAMESPACE_SOAP_11, namespaceURI)) {
            return SoapVersionEnum.V11;
        }
        return SoapVersionEnum.UNKNOWN;
    }
}

