/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.connectors.soap.http.util.stream;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;

public class RestartableInputStream
extends ServletInputStream {
    private InputStream underlyingStream;
    private InputStream bufferStream = null;
    private ByteArrayOutputStream bufferStore = null;
    private boolean recording;

    public RestartableInputStream(InputStream theUnderlyingStream) {
        if (theUnderlyingStream == null) {
            throw new NullPointerException("The underlying stream cannot be null.");
        }
        this.underlyingStream = theUnderlyingStream;
        this.bufferStore = new ByteArrayOutputStream();
        this.recording = true;
    }

    public void restartStream() {
        this.recording = false;
        byte[] data = this.bufferStore.toByteArray();
        this.bufferStore = null;
        this.bufferStream = new ByteArrayInputStream(data);
    }

    public int read() throws IOException {
        this.assertActiveStreamValid();
        if (this.recording) {
            int result = this.underlyingStream.read();
            if (result >= 0) {
                this.bufferStore.write(result);
            }
            return result;
        }
        int result = -1;
        if (this.bufferStream != null && (result = this.bufferStream.read()) < 0) {
            this.bufferStream = null;
        }
        if (result <= 0) {
            result = this.underlyingStream.read();
        }
        return result;
    }

    public int read(byte[] b) throws IOException {
        this.assertActiveStreamValid();
        if (this.recording) {
            int result = this.underlyingStream.read(b);
            if (result > 0) {
                this.bufferStore.write(b, 0, result);
            }
            return result;
        }
        int result = -1;
        if (this.bufferStream != null && (result = this.bufferStream.read(b)) < 0) {
            this.bufferStream = null;
        }
        if (result <= 0) {
            result = this.underlyingStream.read(b);
        }
        return result;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.assertActiveStreamValid();
        if (this.recording) {
            int result = this.underlyingStream.read(b, off, len);
            if (result > 0) {
                this.bufferStore.write(b, off, result);
            }
            return result;
        }
        int result = -1;
        if (this.bufferStream != null && (result = this.bufferStream.read(b, off, len)) < 0) {
            this.bufferStream = null;
        }
        if (result <= 0) {
            result = this.underlyingStream.read(b, off, len);
        }
        return result;
    }

    public long skip(long n) throws IOException {
        this.assertActiveStreamValid();
        if (n <= 0L) {
            return 0L;
        }
        long bytesSkipped = 0L;
        if (this.recording) {
            int bufferSize = (int)Math.min(2048L, n);
            byte[] buffer = new byte[bufferSize];
            int bytesRead = this.underlyingStream.read(buffer);
            if (bytesRead > 0) {
                this.bufferStore.write(buffer, 0, bytesRead);
            }
            bytesSkipped = bytesRead;
        } else if (this.bufferStream != null) {
            long skipped = this.bufferStream.skip(n);
            bytesSkipped += skipped;
            if (skipped < n) {
                long bytesLeftToSkip = n - skipped;
                long skipped2 = this.underlyingStream.skip(bytesLeftToSkip);
                bytesSkipped += skipped2;
            }
        } else {
            bytesSkipped = this.underlyingStream.skip(n);
        }
        return bytesSkipped;
    }

    public int available() throws IOException {
        this.assertActiveStreamValid();
        int bytesAvailable = -1;
        bytesAvailable = this.recording ? this.underlyingStream.available() : (this.bufferStream != null ? this.bufferStream.available() : this.underlyingStream.available());
        return bytesAvailable;
    }

    public void close() throws IOException {
        this.assertActiveStreamValid();
        this.underlyingStream.close();
        if (this.bufferStream != null) {
            try {
                this.bufferStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.bufferStream = null;
        }
    }

    public synchronized void mark(int readlimit) {
        String message = "Marking of stream not suppoted";
        throw new UnsupportedOperationException(message);
    }

    public synchronized void reset() throws IOException {
        String message = "Reset of stream not suppoted";
        throw new UnsupportedOperationException(message);
    }

    public boolean markSupported() {
        return false;
    }

    private void assertActiveStreamValid() throws IOException {
        if (this.underlyingStream == null) {
            throw new IOException("No active stream.");
        }
    }

    public boolean isFinished() {
        return false;
    }

    public boolean isReady() {
        return false;
    }

    public void setReadListener(ReadListener arg0) {
    }
}

