/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.connectors.soap.http.xmlprocessor.http;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import uk.gov.hmrc.aspire.esps.lts.logger.AuditLogger;
import uk.gov.hmrc.aspire.esps.lts.logger.LoggerFactory;
import uk.gov.hmrc.aspire.lts.connectors.soap.http.xmlprocessor.SoapResponse;

public class HttpSoapResponseImpl
implements SoapResponse {
    private HttpServletResponse httpResponse;
    private Map<SoapResponse.ResponseCodeEnum, Integer> resultCodeMap;
    private static AuditLogger logger = LoggerFactory.getAuditLogger();

    public HttpSoapResponseImpl(HttpServletResponse theHttpResponse) {
        this.httpResponse = theHttpResponse;
        this.resultCodeMap = new HashMap<SoapResponse.ResponseCodeEnum, Integer>();
        this.resultCodeMap.put(SoapResponse.ResponseCodeEnum.RC_OK, 200);
        this.resultCodeMap.put(SoapResponse.ResponseCodeEnum.RC_CLIENT_FAULT, 400);
        this.resultCodeMap.put(SoapResponse.ResponseCodeEnum.RC_CLIENT_FAULT_BAD_ENDPOINT, 404);
        this.resultCodeMap.put(SoapResponse.ResponseCodeEnum.RC_SERVER_FAULT, 500);
    }

    @Override
    public void setResultCode(SoapResponse.ResponseCodeEnum theResultCode) {
        Integer responseCode = this.resultCodeMap.get((Object)theResultCode);
        if (responseCode != null) {
            this.httpResponse.setStatus(responseCode.intValue());
        }
    }

    @Override
    public void setContentType(String theContentType) {
        this.httpResponse.setContentType(theContentType);
    }

    @Override
    public OutputStream getStream() {
        ServletOutputStream stream;
        try {
            stream = this.httpResponse.getOutputStream();
        }
        catch (IOException e) {
            logger.audit("Exception getting the output stream from the SOAP Response", e.toString());
            stream = null;
        }
        return stream;
    }
}

