/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.connectors.soap.http.xmlprocessor.stax;

import java.io.OutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import uk.gov.hmrc.aspire.lts.connectors.soap.http.fault.SoapFaultCodeEnum;
import uk.gov.hmrc.aspire.lts.connectors.soap.http.fault.SoapFaultDetail;
import uk.gov.hmrc.aspire.lts.connectors.soap.http.xmlprocessor.SoapMessageBuilder;

public class SoapMessageStaxBuilder
implements SoapMessageBuilder {
    private static final String DEFAULT_ENCODING = "UTF-8";

    @Override
    public void buildFault(OutputStream result, SoapFaultDetail theDetail) {
        try {
            SoapFaultCodeEnum faultCode = theDetail.getCode();
            String faultCodeText = faultCode.getText();
            String reasonText = theDetail.getReason();
            XMLOutputFactory xof = XMLOutputFactory.newInstance();
            XMLStreamWriter xtw = null;
            String SOAP_NS = "http://www.w3.org/2003/05/soap-envelope";
            String SCHEMAINST_NS = "http://www.w3.org/2001/XMLSchema-instance";
            String encoding = DEFAULT_ENCODING;
            xtw = xof.createXMLStreamWriter(result, encoding);
            xtw.writeStartDocument(encoding, "1.0");
            String PREFIX_SOAP = "soap";
            String PREFIX_XSI = "xsi";
            xtw.setPrefix("soap", "http://www.w3.org/2003/05/soap-envelope");
            xtw.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            xtw.writeStartElement("http://www.w3.org/2003/05/soap-envelope", "Envelope");
            xtw.writeNamespace("soap", "http://www.w3.org/2003/05/soap-envelope");
            xtw.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            xtw.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "http://www.w3.org/2003/05/soap-envelope soap12.xsd");
            xtw.writeStartElement("http://www.w3.org/2003/05/soap-envelope", "Body");
            xtw.writeStartElement("http://www.w3.org/2003/05/soap-envelope", "Fault");
            xtw.writeStartElement("http://www.w3.org/2003/05/soap-envelope", "Code");
            xtw.writeStartElement("http://www.w3.org/2003/05/soap-envelope", "Value");
            xtw.writeCharacters("soap:" + faultCodeText);
            xtw.writeEndElement();
            xtw.writeEndElement();
            xtw.writeStartElement("http://www.w3.org/2003/05/soap-envelope", "Reason");
            xtw.writeStartElement("http://www.w3.org/2003/05/soap-envelope", "Text");
            xtw.writeAttribute("xml", "", "lang", "en");
            xtw.writeCharacters(reasonText);
            xtw.writeEndElement();
            xtw.writeEndElement();
            xtw.writeEndElement();
            xtw.writeEndElement();
            xtw.writeEndElement();
            xtw.writeEndDocument();
            xtw.flush();
            xtw.close();
        }
        catch (XMLStreamException xsex) {
            String msg = "Error occurred whilst constructing SOAP fault";
            throw new RuntimeException(msg, xsex);
        }
    }
}

