/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.connectors.soap.http.xmlprocessor.stax;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import uk.gov.hmrc.aspire.esps.lts.logger.AuditLogger;
import uk.gov.hmrc.aspire.esps.lts.logger.LoggerFactory;
import uk.gov.hmrc.aspire.lts.connectors.soap.http.fault.SoapFaultCodeEnum;
import uk.gov.hmrc.aspire.lts.connectors.soap.http.fault.SoapFaultDetail;
import uk.gov.hmrc.aspire.lts.connectors.soap.http.util.InvalidContentTypeException;
import uk.gov.hmrc.aspire.lts.connectors.soap.http.util.SoapContentType;
import uk.gov.hmrc.aspire.lts.connectors.soap.http.util.SoapUtils;
import uk.gov.hmrc.aspire.lts.connectors.soap.http.util.SoapVersionEnum;
import uk.gov.hmrc.aspire.lts.connectors.soap.http.xmlprocessor.InvalidMessageException;
import uk.gov.hmrc.aspire.lts.connectors.soap.http.xmlprocessor.InvalidSoapVersionException;
import uk.gov.hmrc.aspire.lts.connectors.soap.http.xmlprocessor.SoapMessageBuilder;
import uk.gov.hmrc.aspire.lts.connectors.soap.http.xmlprocessor.SoapMessageDetails;
import uk.gov.hmrc.aspire.lts.connectors.soap.http.xmlprocessor.SoapProcessor;
import uk.gov.hmrc.aspire.lts.connectors.soap.http.xmlprocessor.SoapRequest;
import uk.gov.hmrc.aspire.lts.connectors.soap.http.xmlprocessor.SoapResponse;
import uk.gov.hmrc.aspire.lts.connectors.soap.http.xmlprocessor.stax.SoapMessageStaxBuilder;

public class StAXSoapProcessor
implements SoapProcessor {
    private static final QName ROOT_NODE = new QName("http://www.w3.org/2003/05/soap-envelope", "Envelope");
    private static final QName HEADER_NODE = new QName("http://www.w3.org/2003/05/soap-envelope", "Header");
    private static final QName BODY_NODE = new QName("http://www.w3.org/2003/05/soap-envelope", "Body");
    private static final QName ROOT_NODE_2 = new QName("http://www.w3.org/2003/05/soap-envelope/", "Envelope");
    private static final QName HEADER_NODE_2 = new QName("http://www.w3.org/2003/05/soap-envelope/", "Header");
    private static final QName BODY_NODE_2 = new QName("http://www.w3.org/2003/05/soap-envelope/", "Body");
    private static final QName SERVICE_MESSAGE_TYPE = new QName("http://www.hmrc.gov.uk/ws/info-header/1", "ServiceMessageType");
    private static AuditLogger logger = LoggerFactory.getAuditLogger();
    private static final List<QName> EXPECTED_ELEMENTS = new ArrayList<QName>();
    private QName currentNodeOfInterest = null;
    private static XMLInputFactory inputFactory;
    private SoapMessageBuilder msgBuilder = new SoapMessageStaxBuilder();

    @Override
    public SoapMessageDetails processRequest(SoapRequest request) throws InvalidMessageException, InvalidSoapVersionException {
        this.checkContentType(request);
        SoapMessageDetails details = new SoapMessageDetails();
        details = this.parseRequest(request, details);
        return details;
    }

    @Override
    public void generateFaultResponse(SoapResponse theResponse, SoapFaultDetail theDetail) {
        SoapResponse.ResponseCodeEnum resultCode = SoapResponse.ResponseCodeEnum.RC_SERVER_FAULT;
        if (SoapFaultCodeEnum.Sender.equals((Object)theDetail.getCode())) {
            resultCode = SoapResponse.ResponseCodeEnum.RC_CLIENT_FAULT;
        }
        theResponse.setResultCode(resultCode);
        OutputStream out = theResponse.getStream();
        this.msgBuilder.buildFault(out, theDetail);
    }

    @Override
    public void prepareSoapResponse(SoapResponse theResponse) {
        theResponse.setResultCode(SoapResponse.ResponseCodeEnum.RC_OK);
        SoapContentType contentType = null;
        try {
            contentType = new SoapContentType("application/soap+xml");
            contentType.setCharset("UTF-8");
            theResponse.setContentType(contentType.getFullContentType());
        }
        catch (InvalidContentTypeException e) {
            logger.audit("Invalid soap content type set in outgoing response. " + String.valueOf(contentType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private XMLEventReader createStAXEventReader(InputStream messageStream) throws XMLStreamException {
        if (inputFactory == null) {
            Class<StAXSoapProcessor> clazz = StAXSoapProcessor.class;
            // MONITORENTER : uk.gov.hmrc.aspire.lts.connectors.soap.http.xmlprocessor.stax.StAXSoapProcessor.class
            if (inputFactory == null) {
                inputFactory = XMLInputFactory.newInstance();
                inputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
                inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
                inputFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
                inputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
                inputFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
            }
            // MONITOREXIT : clazz
        }
        XMLEventReader reader = null;
        XMLInputFactory xMLInputFactory = inputFactory;
        // MONITORENTER : xMLInputFactory
        reader = inputFactory.createXMLEventReader(messageStream);
        // MONITOREXIT : xMLInputFactory
        return reader;
    }

    private void checkContentType(SoapRequest request) throws InvalidMessageException {
        String contentType = request.getContentType();
        try {
            SoapContentType soapContentType = new SoapContentType(contentType);
            boolean valid = soapContentType.validSoapContentType();
            if (!valid) {
                String MSG_FMT = "The content type was not a valid SOAP content type: \"%s\"";
                String msg = String.format(MSG_FMT, contentType);
                throw new InvalidMessageException(msg);
            }
        }
        catch (InvalidContentTypeException e) {
            String MSG_FMT = "The content type was not a valid SOAP content type: \"%s\"";
            String msg = String.format(MSG_FMT, contentType);
            throw new InvalidMessageException(msg);
        }
    }

    private SoapMessageDetails parseRequest(SoapRequest request, SoapMessageDetails details) throws InvalidMessageException, InvalidSoapVersionException {
        XMLEventReader reader = null;
        SoapMessageDetails tmpdetails = details;
        boolean bodyNodeFound = false;
        boolean rootNodeFound = false;
        try {
            InputStream soapMessage = request.getStream();
            reader = this.createStAXEventReader(soapMessage);
            boolean finished = false;
            int depth = 0;
            boolean isServiceMsgTypeElementFound = false;
            while (!finished && reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                int eventType = event.getEventType();
                switch (eventType) {
                    case 1: {
                        StartElement startElem = event.asStartElement();
                        QName currentNode = startElem.getName();
                        if (depth == 0) {
                            rootNodeFound = true;
                            tmpdetails = this.processRootElement(startElem, tmpdetails);
                        } else if (ROOT_NODE.equals(this.currentNodeOfInterest) || ROOT_NODE_2.equals(this.currentNodeOfInterest)) {
                            if (!(currentNode.equals(HEADER_NODE) || currentNode.equals(HEADER_NODE_2) || currentNode.equals(BODY_NODE) || currentNode.equals(BODY_NODE_2))) {
                                throw new InvalidMessageException("Invalid SOAP message.");
                            }
                        } else if (HEADER_NODE.equals(this.currentNodeOfInterest) || HEADER_NODE_2.equals(this.currentNodeOfInterest)) {
                            if (currentNode.equals(SERVICE_MESSAGE_TYPE)) {
                                isServiceMsgTypeElementFound = true;
                            }
                            if (depth == 1 && !currentNode.equals(BODY_NODE) && !currentNode.equals(BODY_NODE_2)) {
                                throw new InvalidMessageException("Invalid SOAP message.");
                            }
                        } else if (BODY_NODE.equals(this.currentNodeOfInterest) || BODY_NODE_2.equals(this.currentNodeOfInterest)) {
                            tmpdetails = this.processBodyContentElement(startElem, tmpdetails);
                            finished = true;
                        }
                        if (EXPECTED_ELEMENTS.contains(currentNode)) {
                            this.currentNodeOfInterest = currentNode;
                            if (currentNode.getLocalPart().equals("Body")) {
                                bodyNodeFound = true;
                            }
                        }
                        ++depth;
                        break;
                    }
                    case 4: {
                        if (!isServiceMsgTypeElementFound) break;
                        Characters serviceMsgTypeChars = event.asCharacters();
                        tmpdetails = this.getServiceMessageTypeContentElement(serviceMsgTypeChars, tmpdetails);
                        isServiceMsgTypeElementFound = false;
                        break;
                    }
                    case 2: {
                        if (--depth != 0 || bodyNodeFound) break;
                        throw new InvalidMessageException("Invalid SOAP message.");
                    }
                }
            }
        }
        catch (XMLStreamException xsex) {
            String msg = String.format("Invalid SOAP message. Could not parse message successfully - [%s]", xsex.getMessage());
            throw new InvalidMessageException(msg, (Throwable)xsex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (XMLStreamException xMLStreamException) {}
                if (!rootNodeFound) {
                    throw new InvalidMessageException("Invalid SOAP message.");
                }
            }
        }
        return tmpdetails;
    }

    private SoapMessageDetails processRootElement(StartElement startElem, SoapMessageDetails details) throws InvalidMessageException, InvalidSoapVersionException {
        QName name = startElem.getName();
        String elementName = name.getLocalPart();
        if (!"Envelope".equals(elementName)) {
            String msg = String.format("Invalid SOAP message. Root element is not an Envelope - [%s]%n", name.toString());
            throw new InvalidMessageException(msg);
        }
        String namespaceURI = name.getNamespaceURI();
        SoapVersionEnum soapVersion = SoapUtils.deduceSoapVersion(namespaceURI);
        if (!soapVersion.equals((Object)SoapVersionEnum.V12)) {
            if (soapVersion.equals((Object)SoapVersionEnum.UNKNOWN)) {
                String msg = String.format("SOAP version mismatch - [%s]%n", namespaceURI);
                throw new InvalidMessageException(msg);
            }
            String msg = String.format("SOAP version mismatch - [%s]%n", namespaceURI);
            throw new InvalidSoapVersionException(namespaceURI, msg);
        }
        details.setSoapVersion(soapVersion);
        return details;
    }

    private SoapMessageDetails processBodyContentElement(StartElement startElem, SoapMessageDetails details) {
        QName name = startElem.getName();
        String namespaceURI = name.getNamespaceURI();
        details.setBodyContentNS(namespaceURI);
        return details;
    }

    private SoapMessageDetails getServiceMessageTypeContentElement(Characters serviceMsgTypeChars, SoapMessageDetails details) {
        details.setServiceMessageType(serviceMsgTypeChars.getData());
        return details;
    }

    static {
        EXPECTED_ELEMENTS.add(ROOT_NODE);
        EXPECTED_ELEMENTS.add(HEADER_NODE);
        EXPECTED_ELEMENTS.add(BODY_NODE);
        EXPECTED_ELEMENTS.add(ROOT_NODE_2);
        EXPECTED_ELEMENTS.add(HEADER_NODE_2);
        EXPECTED_ELEMENTS.add(BODY_NODE_2);
    }
}

