/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.irmark;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.MessageDigest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.Transforms;
import org.bouncycastle.util.encoders.Base64;
import org.w3c.dom.Document;
import uk.gov.hmrc.aspire.esps.common.encoding.Base32;

public class IRMarkCalc {
    public static final String DEFAULT_SEC_HASH_ALGORITHM = "SHA";
    private String secHashAlg;

    public IRMarkCalc() {
        this.setHashAlgorithm(DEFAULT_SEC_HASH_ALGORITHM);
    }

    public IRMarkCalc(String alg) {
        this.setHashAlgorithm(alg);
    }

    public void setHashAlgorithm(String hashAlg) {
        this.secHashAlg = hashAlg;
    }

    public boolean checkMark(InputStream in, String namespace, String IRmark) throws Exception {
        String newIRMark = this.getMark(in, namespace);
        return newIRMark.equals(IRmark);
    }

    public String getMark(InputStream in, String namespace) throws Exception {
        return IRMarkCalc.toBase64(this.getIRMarkBytes(in, namespace));
    }

    public byte[] getIRMarkBytes(InputStream in, String namespace) throws Exception {
        Init.init();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new ByteArrayInputStream(this.getTransformStForNamespace(namespace).getBytes()));
        Transforms transforms = new Transforms(doc.getDocumentElement(), null);
        XMLSignatureInput input = new XMLSignatureInput(in);
        XMLSignatureInput result = transforms.performTransforms(input);
        MessageDigest md = MessageDigest.getInstance(this.secHashAlg);
        md.update(result.getBytes());
        return md.digest();
    }

    public String getTransformStForNamespace(String namespace) {
        String transformStr = "<?xml version='1.0'?>\n<dsig:Transforms xmlns:dsig='http://www.w3.org/2000/09/xmldsig#' xmlns:gt='http://www.govtalk.gov.uk/CM/envelope' xmlns:ir='" + namespace + "'>\n<dsig:Transform Algorithm='http://www.w3.org/TR/1999/REC-xpath-19991116'>\n<dsig:XPath>\ncount(ancestor-or-self::node()|/gt:GovTalkMessage/gt:Body)=count(ancestor-or-self::node())\n and count(self::ir:IRmark)=0 \n and count(../self::ir:IRmark)=0 \n</dsig:XPath>\n</dsig:Transform>\n<dsig:Transform Algorithm='http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments'/>\n</dsig:Transforms>\n";
        return transformStr;
    }

    public static String toBase32(byte[] irMarkBytes) {
        return Base32.encode(irMarkBytes);
    }

    public static String toBase64(byte[] irMarkBytes) {
        return new String(Base64.encode((byte[])irMarkBytes));
    }

    public static byte[] decodeBase64(String base64Encoded) {
        return Base64.decode((String)base64Encoded);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("Use: IRmark <file> <namespace>");
            return;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(args[0]);
        }
        catch (FileNotFoundException e) {
            System.out.println("The file " + args[0] + " could not be opened.");
            return;
        }
        String namespace = args[1];
        Init.init();
        IRMarkCalc irm = new IRMarkCalc();
        byte[] bytes = irm.getIRMarkBytes(fis, namespace);
        System.out.print("Raw bytes: ");
        for (int index = 0; index < bytes.length; ++index) {
            System.out.print(bytes[index]);
            if (index + 1 >= bytes.length) continue;
            System.out.print(',');
        }
        System.out.println();
        System.out.println("Base32: " + IRMarkCalc.toBase32(bytes));
        System.out.println("Base64: " + IRMarkCalc.toBase64(bytes));
    }
}

