/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.mark;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import uk.gov.hmrc.aspire.lts.mark.MarkCalculator;

public class HMRCMarkCalculator
extends MarkCalculator {
    @Override
    public String getAlgorithm(String namespace) {
        String transformStr = "<?xml version='1.0'?>\n<dsig:Transforms xmlns:dsig='http://www.w3.org/2000/09/xmldsig#' xmlns:soap='http://www.w3.org/2003/05/soap-envelope'>\n<dsig:Transform Algorithm='http://www.w3.org/TR/1999/REC-xpath-19991116'>\n<dsig:XPath>\ncount(ancestor-or-self::node()|/soap:Envelope/soap:Body)=count(ancestor-or-self::node())\n</dsig:XPath>\n</dsig:Transform>\n<dsig:Transform Algorithm='http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments'/>\n</dsig:Transforms>\n";
        return transformStr;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("Usage: HMRCMarkCalculator <file>");
            return;
        }
        File newFile = new File(args[0]);
        if (newFile.isDirectory()) {
            HMRCMarkCalculator.processFolder(newFile, args[0]);
        } else {
            HMRCMarkCalculator.processFile(newFile, args[0]);
        }
    }

    private static void processFile(File newFile, String string) throws Exception {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(newFile);
        }
        catch (FileNotFoundException e) {
            System.out.println("The file " + String.valueOf(newFile) + " could not be opened.");
            return;
        }
        HMRCMarkCalculator mc = new HMRCMarkCalculator();
        System.out.println();
        System.out.println("HMRCmark for file " + newFile.getName());
        System.out.println();
        System.out.println("       Base64 --> " + mc.createMark(fis, null));
        System.out.println();
        System.out.println("       Base32 --> " + mc.getBase32Mark());
        System.out.println();
        System.out.println("============================================================");
    }

    private static void processFolder(File newFolder, String string) throws Exception {
        File[] files;
        System.out.println("Processing folder...");
        for (File newFile : files = newFolder.listFiles()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(newFile);
            }
            catch (FileNotFoundException e) {
                System.out.println("The file " + String.valueOf(newFile) + " could not be opened.");
                return;
            }
            HMRCMarkCalculator mc = new HMRCMarkCalculator();
            System.out.println();
            System.out.println("HMRCmark for file " + newFile.getName());
            System.out.println();
            System.out.println("       Base64 --> " + mc.createMark(fis, null));
            System.out.println();
            System.out.println("       Base32 --> " + mc.getBase32Mark());
            System.out.println();
            System.out.println("============================================================");
        }
    }
}

