/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.mark;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import uk.gov.hmrc.aspire.lts.mark.MarkCalculator;

public class IRMarkCalculator
extends MarkCalculator {
    @Override
    public String getAlgorithm(String namespace) {
        String transformStr = "<?xml version='1.0'?>\n<dsig:Transforms xmlns:dsig='http://www.w3.org/2000/09/xmldsig#' xmlns:gt='http://www.govtalk.gov.uk/CM/envelope' xmlns:ir='" + namespace + "'>\n<dsig:Transform Algorithm='http://www.w3.org/TR/1999/REC-xpath-19991116'>\n<dsig:XPath>count(ancestor-or-self::node()|/gt:GovTalkMessage/gt:Body)=count(ancestor-or-self::node())\n and count(self::ir:IRmark)=0 \n and count(../self::ir:IRmark)=0 \n</dsig:XPath>\n</dsig:Transform>\n<dsig:Transform Algorithm='http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments'/>\n</dsig:Transforms>\n";
        return transformStr;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("Usage: IRMark <file> <namespace>");
            return;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(args[0]);
        }
        catch (FileNotFoundException e) {
            System.out.println("The file " + args[0] + " could not be opened.");
            return;
        }
        IRMarkCalculator mc = new IRMarkCalculator();
        System.out.println();
        System.out.println("IRmark for file " + args[0]);
        System.out.println();
        System.out.println("       Base64 --> " + mc.createMark(fis, args[1]));
        System.out.println();
        System.out.println("       Base32 --> " + mc.getBase32Mark());
        System.out.println();
        System.out.println("============================================================");
    }
}

