/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.mark;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.Transforms;
import org.bouncycastle.util.encoders.Base64;
import org.w3c.dom.Document;
import uk.gov.hmrc.aspire.esps.common.encoding.Base32;

public abstract class MarkCalculator {
    public static final String DEFAULT_SEC_HASH_ALGORITHM = "SHA";
    private byte[] markBytes;

    public boolean checkMark(InputStream in, String namespace, String mark) throws Exception {
        String newIRMark = this.createMark(in, namespace);
        return newIRMark.equals(mark);
    }

    public String createMark(InputStream in, String namespace) throws Exception {
        this.markBytes = this.getMarkBytes(in, namespace);
        return MarkCalculator.toBase64(this.markBytes);
    }

    protected byte[] getMarkBytes(InputStream in, String namespace) throws Exception {
        Init.init();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new ByteArrayInputStream(this.getAlgorithm(namespace).getBytes()));
        Transforms transforms = new Transforms(doc.getDocumentElement(), null);
        XMLSignatureInput input = new XMLSignatureInput(in);
        XMLSignatureInput result = transforms.performTransforms(input);
        MessageDigest md = MessageDigest.getInstance(DEFAULT_SEC_HASH_ALGORITHM);
        md.update(result.getBytes());
        return md.digest();
    }

    protected abstract String getAlgorithm(String var1);

    public String getBase32Mark() {
        return Base32.encode(this.markBytes);
    }

    public static String toBase32(byte[] irMarkBytes) {
        return Base32.encode(irMarkBytes);
    }

    public static String toBase64(byte[] irMarkBytes) {
        return new String(Base64.encode((byte[])irMarkBytes));
    }
}

