/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.fileupload.FileItem;
import uk.gov.hmrc.aspire.lts.LTSSystemException;

public class LTSRequest {
    private String validationNamespace;
    private FileItem originalPayload;
    private FileItem decompressedPayload;
    private String messageType;
    private Properties config;
    private Map<String, String> attribute = new HashMap<String, String>();
    private Map<String, String> metaData;

    public void setAttribute(String name, String value) {
        this.attribute.put(name, value);
    }

    public String getAttribute(String name) {
        return this.attribute.get(name);
    }

    public InputStream getOriginalPayloadInputStream() {
        if (this.originalPayload != null) {
            try {
                return this.originalPayload.getInputStream();
            }
            catch (IOException ioe) {
                throw new LTSSystemException("Unable to obtain InputStream to original payload file", ioe);
            }
        }
        return null;
    }

    public void setOriginalPayload(FileItem originalPayload) {
        this.originalPayload = originalPayload;
    }

    public InputStream getDecompressedPayloadInputStream() {
        if (this.decompressedPayload != null) {
            try {
                return this.decompressedPayload.getInputStream();
            }
            catch (IOException ioe) {
                throw new LTSSystemException("Unable to obtain InputStream to original payload file", ioe);
            }
        }
        return null;
    }

    public void setDecompressedPayload(FileItem decompressedPayload) {
        this.decompressedPayload = decompressedPayload;
    }

    public InputStream getPayloadInputStream() {
        try {
            if (this.decompressedPayload != null) {
                return this.decompressedPayload.getInputStream();
            }
            if (this.originalPayload != null) {
                return this.originalPayload.getInputStream();
            }
        }
        catch (IOException ioe) {
            throw new LTSSystemException("Unable to obtain InputStream to original payload file", ioe);
        }
        return null;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String theMessageType) {
        this.messageType = theMessageType;
    }

    public Properties getConfig() {
        return this.config;
    }

    public void setConfig(Properties config) {
        this.config = config;
    }

    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    public void setMetaData(Map<String, String> metaData) {
        this.metaData = metaData;
    }

    public String getValidationNamespace() {
        return this.validationNamespace;
    }

    public void setValidationNamespace(String validationNamespace) {
        this.validationNamespace = validationNamespace;
    }
}

