/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.receiver;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.commons.fileupload.FileItem;
import uk.gov.hmrc.aspire.esps.lts.logger.AuditLogger;
import uk.gov.hmrc.aspire.esps.lts.logger.LoggerFactory;
import uk.gov.hmrc.aspire.lts.LTSException;
import uk.gov.hmrc.aspire.lts.LTSSystemException;
import uk.gov.hmrc.aspire.lts.composers._IMessageComposer;
import uk.gov.hmrc.aspire.lts.model.LTSRequest;
import uk.gov.hmrc.aspire.lts.model.LTSResponse;
import uk.gov.hmrc.aspire.lts.requesthandlers.HandlerChain;
import uk.gov.hmrc.aspire.lts.requestprocessors.LOBConfigHolder;
import uk.gov.hmrc.aspire.lts.requestprocessors.LOBConfigReader;
import uk.gov.hmrc.aspire.lts.utils.ConfigReader;
import uk.gov.hmrc.aspire.lts.utils.Constants;
import uk.gov.hmrc.aspire.lts.utils.MessageResponse;

public class GovTalkLOBMessageReceiver {
    private LOBConfigReader lobConfigs;
    private static final String PS = Constants.PATH_SEPARATOR;
    private static final String LTS_ROOT = Constants.LTS_ROOT;
    private static final String WS_CONFIG_DIR = LTS_ROOT + PS + "resources" + PS + "config" + PS + "NonConfigurable";
    private final String STATIC_RESPONSES_FILEPATH = LTS_ROOT + PS + "resources" + PS + "responses" + PS;
    private static final String COMPOSER_FQCN_PATH = "uk.gov.hmrc.aspire.lts.composers.";
    private static AuditLogger logger = LoggerFactory.getAuditLogger();

    public OMElement processRequest(FileItem fileItem, String messageNamespace, String messageClass, LOBConfigHolder lobConfigs, String ... taxYear) throws LTSException {
        MessageResponse responseMsg = new MessageResponse();
        if (lobConfigs == null) {
            responseMsg.setOMResponse(this.generateInvalidResponse());
            return responseMsg.getOMResponse();
        }
        logger.audit("Starting processing of 'Get Messages' " + lobConfigs.getLoggingName() + " message");
        ConfigReader reader = new ConfigReader(WS_CONFIG_DIR + PS + lobConfigs.getReceiverConfigFileName());
        Properties config = null;
        try {
            config = reader.getConfig();
        }
        catch (Exception exc) {
            throw new LTSSystemException("Error reading config file - " + WS_CONFIG_DIR + PS + lobConfigs.getReceiverConfigFileName(), exc);
        }
        LTSRequest request = new LTSRequest();
        LTSResponse response = new LTSResponse();
        String configMessageClass = config.getProperty("ServiceMessageType");
        String[] msgClasses = configMessageClass.split(",");
        List<String> msgClassList = Arrays.asList(msgClasses);
        if (msgClassList.contains(messageClass)) {
            request.setMessageType(messageClass);
            request.setOriginalPayload(fileItem);
            if (lobConfigs.getStaticResponseDownload_Ind()) {
                String fullResponseFilePath = this.STATIC_RESPONSES_FILEPATH + lobConfigs.getResponseFolder();
                request.setAttribute("Static", fullResponseFilePath);
            }
            request.setValidationNamespace(messageNamespace);
            request.setConfig(config);
            String[][] classNames = (String[][])config.get("Handlers");
            HandlerChain chain = HandlerChain.getChain(classNames);
            try {
                chain.process(request, response);
            }
            catch (Exception e) {
                throw new LTSSystemException("Error initiating/processing the incoming message.\n" + e.getMessage(), e);
            }
            responseMsg.setOMResponse(this.composeResponse(request, response, COMPOSER_FQCN_PATH + lobConfigs.getComposerName()));
        } else {
            responseMsg.setOMResponse(this.generateInvalidResponse());
        }
        return responseMsg.getOMResponse();
    }

    private OMElement composeResponse(LTSRequest request, LTSResponse response, String composerFQCN) throws LTSSystemException {
        boolean instantiationFailure = false;
        String errorMessage = null;
        Exception errorException = null;
        _IMessageComposer composer = null;
        try {
            Class<?> composerClassGeneric = Class.forName(composerFQCN);
            composer = (_IMessageComposer)composerClassGeneric.newInstance();
        }
        catch (ClassNotFoundException ex) {
            instantiationFailure = true;
            String ERR_FMT = "Specified composer class not found: %s";
            errorMessage = String.format("Specified composer class not found: %s", composerFQCN);
            errorException = ex;
        }
        catch (ClassCastException ex) {
            instantiationFailure = true;
            String ERR_FMT = "Specified composer class does implement the correct interface: %s";
            errorMessage = String.format("Specified composer class does implement the correct interface: %s", composerFQCN);
            errorException = ex;
        }
        catch (IllegalAccessException ex) {
            instantiationFailure = true;
            String ERR_FMT = "IllegalAccessException when creating composer: %s";
            errorMessage = String.format("IllegalAccessException when creating composer: %s", composerFQCN);
            errorException = ex;
        }
        catch (InstantiationException ex) {
            instantiationFailure = true;
            String ERR_FMT = "InstantiationException when creating composer: %s";
            errorMessage = String.format("InstantiationException when creating composer: %s", composerFQCN);
            errorException = ex;
        }
        if (instantiationFailure) {
            logger.audit("Problem processing Message Request: " + errorMessage);
            throw new LTSSystemException("Error initiating/processing the incoming message.\n" + errorMessage, errorException);
        }
        return composer.composeMessage(request, response);
    }

    private OMElement generateInvalidResponse() {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace errorRespNamespace = factory.createOMNamespace("http://www.govtalk.gov.uk/CM/errorresponse", "");
        OMElement errorResponse = factory.createOMElement("ErrorResponse", errorRespNamespace);
        OMElement application = factory.createOMElement("Application", errorRespNamespace, (OMContainer)errorResponse);
        OMElement messageCount = factory.createOMElement("MessageCount", errorRespNamespace, (OMContainer)application);
        messageCount.addChild((OMNode)factory.createOMText("1"));
        OMElement error = factory.createOMElement("Error", errorRespNamespace, (OMContainer)errorResponse);
        OMElement raisedBy = factory.createOMElement("RaisedBy", errorRespNamespace, (OMContainer)error);
        raisedBy.addChild((OMNode)factory.createOMText("ChRIS"));
        OMElement numberNode = factory.createOMElement("Number", errorRespNamespace, (OMContainer)error);
        numberNode.addChild((OMNode)factory.createOMText("8998"));
        OMElement typeNode = factory.createOMElement("Type", errorRespNamespace, (OMContainer)error);
        typeNode.addChild((OMNode)factory.createOMText("business"));
        OMElement textNode = factory.createOMElement("Text", errorRespNamespace, (OMContainer)error);
        textNode.addChild((OMNode)factory.createOMText("Please check that the correct 'Message Type' has been specified in your xml file and that your submission contains no invalid characters."));
        OMElement locationNode = factory.createOMElement("Location", errorRespNamespace, (OMContainer)error);
        locationNode.addChild((OMNode)factory.createOMText("/Envelope/Header/Info/ServiceMessageType"));
        return errorResponse;
    }
}

