/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.receiver;

import java.util.Properties;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.commons.fileupload.FileItem;
import uk.gov.hmrc.aspire.esps.lts.logger.AuditLogger;
import uk.gov.hmrc.aspire.esps.lts.logger.LoggerFactory;
import uk.gov.hmrc.aspire.lts.LTSException;
import uk.gov.hmrc.aspire.lts.LTSSystemException;
import uk.gov.hmrc.aspire.lts.composers.MessageComposer;
import uk.gov.hmrc.aspire.lts.model.LTSRequest;
import uk.gov.hmrc.aspire.lts.model.LTSResponse;
import uk.gov.hmrc.aspire.lts.requesthandlers.HandlerChain;
import uk.gov.hmrc.aspire.lts.spox.GovTalkListener;
import uk.gov.hmrc.aspire.lts.utils.ConfigReader;
import uk.gov.hmrc.aspire.lts.utils.Constants;
import uk.gov.hmrc.aspire.lts.utils.MessageResponse;
import uk.gov.hmrc.aspire.lts.utils.Utils;
import uk.gov.hmrc.chris.spox.Listener;
import uk.gov.hmrc.chris.spox.XMLHandler;

public class GovTalkPAYERTIEYUMessageReceiver {
    private static final String PS = Constants.PATH_SEPARATOR;
    private static final String LTS_ROOT = Constants.LTS_ROOT;
    private static final String WS_CONFIG_DIR = LTS_ROOT + PS + "resources" + PS + "config" + PS + "NonConfigurable";
    private static final String CONFIG_FILE = "PAYERTI-EYU-Config.xml";
    private static final String STATIC_RESPONSES_FILEPATH = LTS_ROOT + PS + "resources" + PS + "responses" + PS + "PAYERTI" + PS + "EYU";
    private static AuditLogger logger = LoggerFactory.getAuditLogger();

    public OMElement processRequest(FileItem fileItem, String remoteHost, StringBuffer requestURL) throws LTSException {
        MessageResponse responseMsg = new MessageResponse();
        logger.audit("Starting processing of 'Get Messages' PAYERTI message");
        ConfigReader reader = new ConfigReader(WS_CONFIG_DIR + PS + CONFIG_FILE);
        Properties config = null;
        try {
            config = reader.getConfig();
        }
        catch (Exception exc) {
            throw new LTSSystemException("Error reading config file - " + WS_CONFIG_DIR + PS + CONFIG_FILE, exc);
        }
        LTSRequest request = new LTSRequest();
        LTSResponse response = new LTSResponse();
        GovTalkListener govTalkListener = new GovTalkListener();
        try {
            XMLHandler handler = new XMLHandler(new Listener[]{govTalkListener});
            handler.readXML(fileItem.getInputStream());
        }
        catch (Exception e) {
            throw new LTSException("Message processing failed: " + Utils.getRootCause(e).getMessage(), e);
        }
        String messageClass = govTalkListener.getMessageClass();
        String messageNamespace = govTalkListener.getMessageNamespace();
        String configMessageClass = config.getProperty("ServiceMessageType");
        if (!configMessageClass.equals(messageClass) && !(configMessageClass + "-TIL").equals(messageClass)) {
            responseMsg.setOMResponse(this.generateInvalidResponse());
        } else {
            request.setOriginalPayload(fileItem);
            request.setMessageType(messageClass);
            request.setAttribute("Static", STATIC_RESPONSES_FILEPATH);
            request.setValidationNamespace(messageNamespace);
            request.setConfig(config);
            String[][] classNames = (String[][])config.get("Handlers");
            HandlerChain chain = HandlerChain.getChain(classNames);
            try {
                chain.process(request, response);
            }
            catch (Exception e) {
                throw new LTSSystemException("Error initiating/processing the incoming message.\n" + e.getMessage(), e);
            }
            MessageComposer composer = new MessageComposer();
            responseMsg.setOMResponse(composer.composeMessage(request, response));
        }
        return responseMsg.getOMResponse();
    }

    public OMElement generateInvalidResponse() {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace errorRespNamespace = factory.createOMNamespace("http://www.govtalk.gov.uk/CM/errorresponse", "");
        OMElement errorResponse = factory.createOMElement("ErrorResponse", errorRespNamespace);
        OMElement application = factory.createOMElement("Application", errorRespNamespace, (OMContainer)errorResponse);
        OMElement messageCount = factory.createOMElement("MessageCount", errorRespNamespace, (OMContainer)application);
        messageCount.addChild((OMNode)factory.createOMText("1"));
        OMElement error = factory.createOMElement("Error", errorRespNamespace, (OMContainer)errorResponse);
        OMElement raisedBy = factory.createOMElement("RaisedBy", errorRespNamespace, (OMContainer)error);
        raisedBy.addChild((OMNode)factory.createOMText("ChRIS"));
        OMElement numberNode = factory.createOMElement("Number", errorRespNamespace, (OMContainer)error);
        numberNode.addChild((OMNode)factory.createOMText("8998"));
        OMElement typeNode = factory.createOMElement("Type", errorRespNamespace, (OMContainer)error);
        typeNode.addChild((OMNode)factory.createOMText("business"));
        OMElement textNode = factory.createOMElement("Text", errorRespNamespace, (OMContainer)error);
        textNode.addChild((OMNode)factory.createOMText("Please check that the correct 'Message Type' has been specified in your xml file and that your submission contains no invalid characters."));
        OMElement locationNode = factory.createOMElement("Location", errorRespNamespace, (OMContainer)error);
        locationNode.addChild((OMNode)factory.createOMText("/Envelope/Header/Info/ServiceMessageType"));
        return errorResponse;
    }
}

