/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.requesthandlers;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import uk.gov.hmrc.aspire.lts.LTSSystemException;
import uk.gov.hmrc.aspire.lts.model.LTSRequest;
import uk.gov.hmrc.aspire.lts.model.LTSResponse;
import uk.gov.hmrc.aspire.lts.requesthandlers.HandlerChain;

public abstract class AbstractMetaDataHandler
extends HandlerChain {
    @Override
    protected boolean handleRequest(LTSRequest ltsRequest, LTSResponse ltsResponse) {
        Map<String, String> metaData = this.getMetaData(ltsRequest);
        if (metaData == null) {
            throw new LTSSystemException("Cannot load metadata for incoming message. Message Type = " + ltsRequest.getMessageType());
        }
        metaData.put("GatewayTimestamp", this.getGatewayTimestamp());
        String correlationID = metaData.get("CorrelationID");
        if (correlationID == null || correlationID.trim().length() == 0) {
            metaData.put("CorrelationID", this.getRandomNumber());
        }
        ltsRequest.setMetaData(metaData);
        return true;
    }

    protected abstract Map<String, String> getMetaData(LTSRequest var1);

    private final String getGatewayTimestamp() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.mmm");
        return sdf.format(new Date());
    }

    private final String getRandomNumber() {
        Random random = new Random();
        long value = Math.abs(random.nextLong());
        return "" + value;
    }
}

