/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.requesthandlers;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import uk.gov.hmrc.aspire.esps.lts.logger.AuditLogger;
import uk.gov.hmrc.aspire.esps.lts.logger.LoggerFactory;
import uk.gov.hmrc.aspire.lts.LTSSystemException;
import uk.gov.hmrc.aspire.lts.model.LTSRequest;
import uk.gov.hmrc.aspire.lts.model.LTSResponse;
import uk.gov.hmrc.aspire.lts.requesthandlers.HandlerChain;
import uk.gov.hmrc.aspire.lts.utils.Constants;

public class AuthenticationHandler
extends HandlerChain {
    private AuditLogger logger = LoggerFactory.getAuditLogger();

    @Override
    protected boolean handleRequest(LTSRequest ltsRequest, LTSResponse ltsResponse) {
        this.logger.audit(ltsRequest.getValidationNamespace() + "\t" + ltsRequest.getMetaData().get("CorrelationID") + "\tValidating payload - User credentials.");
        String username = ltsRequest.getMetaData().get("Username");
        String staticFileDirectory = ltsRequest.getAttribute("Authentication");
        if (username == null) {
            username = "error_auth";
            try {
                File staticFile = new File(staticFileDirectory + Constants.PATH_SEPARATOR + username + ".xml");
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(staticFile));
                XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(bis);
                StAXOMBuilder builder = new StAXOMBuilder(parser);
                OMElement doc = builder.getDocumentElement();
                ltsResponse.setStaticResponseData(doc);
            }
            catch (Exception e) {
                throw new LTSSystemException(e);
            }
            return false;
        }
        File staticFile = new File(staticFileDirectory + Constants.PATH_SEPARATOR + username + ".xml");
        if (staticFile.exists() & username.equals(Constants.AUTH_FAILURE_USSERNAME)) {
            try {
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(staticFile));
                XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(bis);
                StAXOMBuilder builder = new StAXOMBuilder(parser);
                OMElement doc = builder.getDocumentElement();
                ltsResponse.setStaticResponseData(doc);
            }
            catch (Exception e) {
                throw new LTSSystemException(e);
            }
            return false;
        }
        return true;
    }
}

