/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.requesthandlers;

import com.decisionsoft.rim.calc.CalculationValidator;
import com.decisionsoft.rim.calc.CalculationValidatorException;
import com.decisionsoft.rim.calc.CalculationValidatorFactory;
import com.decisionsoft.rim.calc.InvalidNamespaceException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import uk.gov.hmrc.aspire.esps.lts.logger.AuditLogger;
import uk.gov.hmrc.aspire.esps.lts.logger.LoggerFactory;
import uk.gov.hmrc.aspire.lts.LTSSystemException;
import uk.gov.hmrc.aspire.lts.model.LTSRequest;
import uk.gov.hmrc.aspire.lts.model.LTSResponse;
import uk.gov.hmrc.aspire.lts.requesthandlers.HandlerChain;
import uk.gov.hmrc.aspire.lts.spox.CalcErrorsListener;
import uk.gov.hmrc.chris.spox.Listener;
import uk.gov.hmrc.chris.spox.XMLHandler;

public class CalcHandler
extends HandlerChain {
    private AuditLogger logger = LoggerFactory.getAuditLogger();

    @Override
    protected boolean handleRequest(LTSRequest ltsRequest, LTSResponse ltsResponse) {
        boolean isValid;
        block11: {
            isValid = false;
            boolean Calc = false;
            boolean calculatorFound = false;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            String namespaceURI = ltsRequest.getValidationNamespace();
            String CT_UNIFIED_RATE_NAMESPACE = "http://www.govtalk.gov.uk/taxation/CT/5";
            CalculationValidator calculator = null;
            try {
                calculator = CalculationValidatorFactory.INSTANCE.newInstance(namespaceURI);
                if (calculator != null) {
                    calculatorFound = true;
                }
                InputStream in = ltsRequest.getPayloadInputStream();
                if (calculatorFound) {
                    try {
                        this.logger.audit("CALCULATION BEING PERFORMED FOR NAMESPACE: \"" + namespaceURI + "\"...");
                        calculator.validate(in, (OutputStream)baos);
                        String calculationResult = baos.toString("UTF-8");
                        int errorCount = CalcHandler.countCalculationErrors(calculationResult);
                        if (errorCount > 0) {
                            this.logger.audit("CALCULATION FAILURE. ERROR COUNT: " + errorCount);
                            ByteArrayInputStream bais = new ByteArrayInputStream(calculationResult.getBytes("UTF-8"));
                            CalcErrorsListener listener = new CalcErrorsListener(ltsResponse);
                            XMLHandler handler = new XMLHandler(new Listener[]{listener});
                            handler.readXML((InputStream)bais);
                        } else {
                            isValid = true;
                            this.logger.audit("CALCULATION COMPLETE");
                        }
                        break block11;
                    }
                    catch (IOException ioe) {
                        throw new LTSSystemException(ioe);
                    }
                    catch (InvalidNamespaceException insEx) {
                        throw new LTSSystemException("An Invalid Namespace Has Been Provided" + insEx.getMessage(), insEx);
                    }
                    catch (CalculationValidatorException cve) {
                        throw new LTSSystemException(cve);
                    }
                }
                this.logger.audit("MESSAGE CLASS NOT SENT TO CALCULATOR");
            }
            catch (InvalidNamespaceException ine) {
                throw new LTSSystemException("An Invalid Namespace Has Been Provided" + ine.getMessage(), ine);
            }
            catch (Exception e) {
                throw new LTSSystemException("Error thrown from the calculator engine" + e.getMessage(), e);
            }
        }
        return isValid;
    }

    protected static final int countCalculationErrors(String response) {
        int index = 0;
        int count = 0;
        while ((index = response.indexOf("<err:Error>", index)) > -1) {
            ++count;
            ++index;
        }
        return count;
    }
}

