/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.requesthandlers;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.om.OMNode;
import uk.gov.hmrc.aspire.lts.LTSSystemException;
import uk.gov.hmrc.aspire.lts.model.LTSRequest;
import uk.gov.hmrc.aspire.lts.model.LTSResponse;
import uk.gov.hmrc.aspire.lts.requesthandlers.HandlerChain;
import uk.gov.hmrc.aspire.lts.utils.Constants;
import uk.gov.hmrc.aspire.lts.utils.OMElementUtils;
import uk.gov.hmrc.aspire.lts.xmlparsing.XmlHarvester;
import uk.gov.hmrc.aspire.lts.xmlparsing.XmlParserStax;
import uk.gov.hmrc.aspire.lts.xmlparsing.XmlPath;

public class CharityDownloadHandler
extends HandlerChain {
    private static final String MESSAGE_CLASS = "MessageClass";
    private static final String CLAIM_NO = "ClaimNo";
    private static final String SINGLE_CLAIM_MESSAGE_CLASS = "HMRC-CHAR-CLM";
    private static final String DONATION_COUNT = "DonationsCount";
    private static final String DONATION_XPATH = "/env:GovTalkMessage/env:Body/r68:IRenvelope/r68:R68/r68:Claim/r68:Repayment/r68:GAD.count()";
    public static final int DONATION_LIMIT = 500000;

    @Override
    protected boolean handleRequest(LTSRequest request, LTSResponse response) throws Exception {
        int donationCount;
        String claimNo = request.getMetaData().get(CLAIM_NO);
        Boolean charityRefStatusFlag = true;
        Boolean donationCountstatusFlag = true;
        Boolean returnStatusFlag = true;
        String errorNum = "";
        if (SINGLE_CLAIM_MESSAGE_CLASS.equalsIgnoreCase(request.getMetaData().get(MESSAGE_CLASS)) && claimNo != null && claimNo.startsWith("7020")) {
            errorNum = "7020";
            charityRefStatusFlag = this.performStaticErrorRetrieval(request, response, errorNum);
        }
        if ((donationCount = this.performDonationCount(request)) > 500000) {
            errorNum = "7058";
            donationCountstatusFlag = this.performStaticErrorRetrieval(request, response, errorNum);
        }
        if (!charityRefStatusFlag.booleanValue() || !donationCountstatusFlag.booleanValue()) {
            returnStatusFlag = false;
        }
        return returnStatusFlag;
    }

    private int performDonationCount(LTSRequest request) {
        XmlParserStax parser = new XmlParserStax();
        HashMap<String, String> namespaceMap = new HashMap<String, String>();
        namespaceMap.put("env", "http://www.govtalk.gov.uk/CM/envelope");
        namespaceMap.put("r68", "http://www.govtalk.gov.uk/taxation/charities/r68/1");
        HashMap<XmlPath, String> harvestMap = new HashMap<XmlPath, String>();
        harvestMap.put(new XmlPath(DONATION_XPATH, namespaceMap), DONATION_COUNT);
        XmlHarvester xmlHarvester = new XmlHarvester(harvestMap);
        parser.parse(request.getPayloadInputStream(), xmlHarvester);
        Map<String, String> data = xmlHarvester.getHarvestedData();
        if (data.get(DONATION_COUNT) != null) {
            return Integer.valueOf(data.get(DONATION_COUNT));
        }
        return 0;
    }

    private boolean performStaticErrorRetrieval(LTSRequest request, LTSResponse response, String errorNum) {
        String staticFileDirectory = request.getAttribute("Static");
        File staticFile = new File(staticFileDirectory + Constants.PATH_SEPARATOR + errorNum + ".xml");
        if (!staticFile.exists()) {
            return this.haveWePassed(response.getErrors());
        }
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(staticFile));
            OMNode node = OMElementUtils.getOMNode(bis);
            response.addError("download", node);
            return false;
        }
        catch (Exception e) {
            throw new LTSSystemException(e);
        }
    }

    private boolean haveWePassed(Map<String, OMNode> errors) {
        return errors.isEmpty();
    }
}

