/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.requesthandlers;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.axiom.om.OMNode;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import uk.gov.hmrc.aspire.lts.model.LTSRequest;
import uk.gov.hmrc.aspire.lts.model.LTSResponse;
import uk.gov.hmrc.aspire.lts.requesthandlers.HandlerChain;
import uk.gov.hmrc.aspire.lts.spox.DecompressionDataListener;
import uk.gov.hmrc.aspire.lts.spox.MultipleCompressedElementsException;
import uk.gov.hmrc.aspire.lts.utils.OMElementUtils;
import uk.gov.hmrc.chris.spox.Listener;
import uk.gov.hmrc.chris.spox.XMLHandler;

public class DecompressionHandler
extends HandlerChain {
    public static final String COMPRESSED_PART_XPATH_PROPERTY = "CompressedPartXPath";
    public static final String COMPRESSION_TYPE_ATTRIBUTE_NAME_PROPERTY = "CompressionTypeAttributeName";
    public static final String COMPRESSION_SIZE_CHECK_IND = "CompressionSizeCheckInd";
    public static final String COMPRESSION_SIZE_LIMIT = "CompressionSizeLimit";
    public static final String ALTERNATIVE_MULTI_COMPRESSED_PARTS_ERROR = "AlternateMultiCompressedPartsError";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean handleRequest(LTSRequest ltsRequest, LTSResponse ltsResponse) throws Exception {
        Properties config = ltsRequest.getConfig();
        DiskFileItemFactory fileItemFactory = new DiskFileItemFactory();
        fileItemFactory.setSizeThreshold(0x100000);
        FileItem fileItem = fileItemFactory.createItem("payload", "text/xml", false, null);
        OutputStream out = fileItem.getOutputStream();
        DecompressionDataListener decompressionListener = new DecompressionDataListener(out, this.determineSubmissionCompressionXPath(ltsRequest), config.getProperty(COMPRESSION_TYPE_ATTRIBUTE_NAME_PROPERTY));
        try {
            XMLHandler handler = new XMLHandler(new Listener[]{decompressionListener});
            handler.readXML(ltsRequest.getOriginalPayloadInputStream());
        }
        catch (MultipleCompressedElementsException mcee) {
            OMNode error;
            String msgText;
            if ("Y".equalsIgnoreCase(config.getProperty(ALTERNATIVE_MULTI_COMPRESSED_PARTS_ERROR))) {
                msgText = "Invalid content found at element 'CompressedPart'";
                error = OMElementUtils.getErrorNode("4065", "business", "Invalid content found at element 'CompressedPart'", "CompressedPart");
            } else {
                msgText = "Your submission is not in the correct format - please contact your software supplier and quote Error Code 6010.";
                error = OMElementUtils.getErrorNode("6010", "schema-validation", "Your submission is not in the correct format - please contact your software supplier and quote Error Code 6010.", mcee.getXPath());
            }
            ltsResponse.addError("compression", error);
            boolean msgText2 = false;
            return msgText2;
        }
        catch (Exception e) {
            String msgText = "Failure to process the compressed file";
            OMNode error = OMElementUtils.getErrorNode("7521", "business", "Failure to process the compressed file", "CompressedPart");
            ltsResponse.addError("compression", error);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                out.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace(System.err);
            }
        }
        ltsRequest.setDecompressedPayload(fileItem);
        boolean compSizeCheckPass = true;
        if (decompressionListener.getCompressedSubmissionFlag() && "ON".equalsIgnoreCase(config.getProperty(COMPRESSION_SIZE_CHECK_IND)) && fileItem.getSize() > Long.parseLong(config.getProperty(COMPRESSION_SIZE_LIMIT))) {
            String msgText = "Decompressed file size exceeds 100MB";
            OMNode error = OMElementUtils.getErrorNode("7062", "business", "Decompressed file size exceeds 100MB", "CompressedPart");
            ltsResponse.addError("compression", error);
            compSizeCheckPass = false;
        }
        return compSizeCheckPass;
    }

    public String determineSubmissionCompressionXPath(LTSRequest ltsRequest) {
        return ltsRequest.getConfig().getProperty(COMPRESSED_PART_XPATH_PROPERTY);
    }
}

