/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.requesthandlers;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import uk.gov.hmrc.aspire.lts.LTSSystemException;
import uk.gov.hmrc.aspire.lts.model.LTSRequest;
import uk.gov.hmrc.aspire.lts.model.LTSResponse;
import uk.gov.hmrc.aspire.lts.requesthandlers.HandlerChain;
import uk.gov.hmrc.aspire.lts.utils.Constants;

public class GovTalkDownloadHandler
extends HandlerChain {
    @Override
    protected boolean handleRequest(LTSRequest request, LTSResponse response) throws Exception {
        String username = request.getMetaData().get("Credential");
        String staticFileDirectory = request.getAttribute("Static");
        File staticFile = new File(staticFileDirectory + Constants.PATH_SEPARATOR + username + ".xml");
        if (staticFile.exists()) {
            try {
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(staticFile));
                XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(bis);
                StAXOMBuilder builder = new StAXOMBuilder(parser);
                OMElement doc = builder.getDocumentElement();
                response.setStaticResponseData(doc);
            }
            catch (Exception e) {
                throw new LTSSystemException(e);
            }
        }
        return true;
    }
}

