/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.requesthandlers;

import java.io.InputStream;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import uk.gov.hmrc.aspire.esps.lts.logger.AuditLogger;
import uk.gov.hmrc.aspire.esps.lts.logger.LoggerFactory;
import uk.gov.hmrc.aspire.lts.LTSSystemException;
import uk.gov.hmrc.aspire.lts.mark.HMRCMarkCalculator;
import uk.gov.hmrc.aspire.lts.model.LTSRequest;
import uk.gov.hmrc.aspire.lts.model.LTSResponse;
import uk.gov.hmrc.aspire.lts.requesthandlers.HandlerChain;
import uk.gov.hmrc.aspire.lts.utils.OMElementUtils;

public class HMRCMarkHandler
extends HandlerChain {
    private AuditLogger logger = LoggerFactory.getAuditLogger();

    @Override
    protected boolean handleRequest(LTSRequest request, LTSResponse response) {
        this.logger.audit(request.getValidationNamespace() + "\t" + request.getMetaData().get("CorrelationID") + "\tValidating payload - HMRCMark.");
        String hmrcMark = request.getMetaData().get("IR_HMRC_Mark");
        boolean isValid = false;
        if (hmrcMark != null && hmrcMark.length() > 0) {
            OMFactory factory = OMAbstractFactory.getOMFactory();
            HMRCMarkCalculator calc = new HMRCMarkCalculator();
            try {
                InputStream payload = request.getOriginalPayloadInputStream();
                isValid = calc.checkMark(payload, null, hmrcMark);
                if (isValid) {
                    this.logger.audit(request.getValidationNamespace() + "\t" + request.getMetaData().get("CorrelationID") + "\tThe supplied HMRCMark is valid.");
                    boolean TPVS_message = false;
                    if (request.getMessageType().endsWith("TIL")) {
                        TPVS_message = true;
                    }
                    String base32mark = "";
                    if (!TPVS_message) {
                        base32mark = calc.getBase32Mark();
                    }
                    OMNamespace xsiNamespace = factory.createOMNamespace("http://www.w3.org/2001/XMLSchema-instance", "xsi");
                    OMNamespace digSigNamespace = factory.createOMNamespace("http://www.w3.org/2000/09/xmldsig#", "dsig");
                    OMNamespace successRespNamespace = factory.createOMNamespace("http://www.inlandrevenue.gov.uk/SuccessResponse", "");
                    OMNamespace soapNamespace = factory.createOMNamespace("http://www.w3.org/2003/05/soap-envelope", "soap");
                    OMElement hmrcMarkReceipt = factory.createOMElement("IRmarkReceipt", successRespNamespace);
                    OMElement signature = factory.createOMElement("Signature", digSigNamespace, (OMContainer)hmrcMarkReceipt);
                    signature.declareNamespace(xsiNamespace);
                    OMElement signedInfo = factory.createOMElement("SignedInfo", digSigNamespace, (OMContainer)signature);
                    signedInfo.declareNamespace(soapNamespace);
                    OMElement canonicalizationMethod = factory.createOMElement("CanonicalizationMethod", digSigNamespace, (OMContainer)signedInfo);
                    OMAttribute cnclAttribute = factory.createOMAttribute("Algorithm", null, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
                    canonicalizationMethod.addAttribute(cnclAttribute);
                    OMElement signatureMethod = factory.createOMElement("SignatureMethod", digSigNamespace, (OMContainer)signedInfo);
                    OMAttribute signMethAttribute = factory.createOMAttribute("Algorithm", null, "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
                    signatureMethod.addAttribute(signMethAttribute);
                    OMElement reference = factory.createOMElement("Reference", digSigNamespace, (OMContainer)signedInfo);
                    OMElement transforms = factory.createOMElement("Transforms", digSigNamespace, (OMContainer)reference);
                    OMElement transform = factory.createOMElement("Transform", digSigNamespace, (OMContainer)transforms);
                    OMAttribute transformAttribute = factory.createOMAttribute("Algorithm", null, "http://www.w3.org/TR/1999/REC-xpath-19991116");
                    transform.addAttribute(transformAttribute);
                    OMElement xPath = factory.createOMElement("XPath", digSigNamespace, (OMContainer)transform);
                    xPath.addChild((OMNode)factory.createOMText("count(ancestor-or-self::node()|//soap:Envelope/soap:Body)=count(ancestor-or-self::node())"));
                    OMElement transform2 = factory.createOMElement("Transform", digSigNamespace, (OMContainer)transforms);
                    OMAttribute transformAttribute2 = factory.createOMAttribute("Algorithm", null, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
                    transform2.addAttribute(transformAttribute2);
                    OMElement digestMethod = factory.createOMElement("DigestMethod", digSigNamespace, (OMContainer)reference);
                    OMAttribute digsetAttribute = factory.createOMAttribute("Algorithm", null, "http://www.w3.org/2000/09/xmldsig#sha1");
                    digestMethod.addAttribute(digsetAttribute);
                    OMElement digestValue = factory.createOMElement("DigestValue", digSigNamespace, (OMContainer)reference);
                    digestValue.addChild((OMNode)factory.createOMText(hmrcMark));
                    OMElement signatureValue = factory.createOMElement("SignatureValue", digSigNamespace, (OMContainer)signature);
                    signatureValue.addChild((OMNode)factory.createOMText("ov+vziKsXzCpAHOZskSSp5yJptHB+fFilM8iaV3Agy7W9/xyqQfj98+uiOBqP73mwUzmZ9dyF7OQXIg75X/AgwNUHKGvId7i+L+XxlvCDoPm1QwBX+wliaCLXEXC9u2QHTDjz+8sUjyogZDlHJJdvfgEnhrX9kT4Ge9C4TAQRtQ="));
                    OMElement keyInfo = factory.createOMElement("KeyInfo", digSigNamespace, (OMContainer)signature);
                    OMElement x509Data = factory.createOMElement("X509Data", digSigNamespace, (OMContainer)keyInfo);
                    OMElement x509Certificate = factory.createOMElement("X509Certificate", digSigNamespace, (OMContainer)x509Data);
                    x509Certificate.addChild((OMNode)factory.createOMText("MIIDKTCCApKgAwIBAgIBAjANBgkqhkiG9w0BAQQFADB1MQswCQYDVQQGEwJVUzERMA8GA1UECBMISWxsaW5vaXMxGTAXBgNVBAcTEE9ha2Jyb29rIFRlcnJhY2UxEDAOBgNVBAoTB1NhcnZlZ2ExEDAOBgNVBAsTB1N1cHBvcnQxFDASBgNVBAMTC1NhcnZlZ2FEZW1vMB4XDTA0MTAwNzE2MDYwOFoXDTI5MTAwMTE2MDYwOFoweTELMAkGA1UEBhMCVVMxETAPBgNVBAgTCElsbGlub2lzMRkwFwYDVQQHExBPYWticm9vayBUZXJyYWNlMRAwDgYDVQQKEwdTYXJ2ZWdhMRAwDgYDVQQLEwdTdXBwb3J0MRgwFgYDVQQDEw9TYXJ2ZWdhRGVtb0NlcnQwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAOuak58DVFSXNRJzyvthjWYBn+yQX67cemqa1ZVF460RuwOCODZJHP8KlLnrJyZHVuBzlA0yHGKz5ABjpj/N7/IWxrC4LEH0Tuw1WCqaDTaSV2AtyEs7fgtopit6KM/yMGwqrDSHcuMi++yr5ynhfOS5uWZ9dSYwwmCtLmEauayfAgMBAAGjgcQwgcEwHQYDVR0OBBYEFH5QwQCCP0EqP0vwyRifonAT46ooMIGfBgNVHSMEgZcwgZSAFGU/dbDLz6UwZVm9DPwTghnj4tt6oXmkdzB1MQswCQYDVQQGEwJVUzERMA8GA1UECBMISWxsaW5vaXMxGTAXBgNVBAcTEE9ha2Jyb29rIFRlcnJhY2UxEDAOBgNVBAoTB1NhcnZlZ2ExEDAOBgNVBAsTB1N1cHBvcnQxFDASBgNVBAMTC1NhcnZlZ2FEZW1vggEAMA0GCSqGSIb3DQEBBAUAA4GBAJ7UjONH53zehnwbxNmLsr2FtdDSkQL9JFPEctPrjThu8w+4m/C8u+spUnIdPr9P3f5870L3/+EcePsXAc00xx4uqsrCkCD2unpKO7ZO0fqmvd2dMQqpcQv5Lm7jQa1HpmRcNwGiQhslp0K+oCxds2w4jZWt7W/l/H0Htg6kRnzD"));
                    OMElement message = factory.createOMElement("Message", successRespNamespace, (OMContainer)hmrcMarkReceipt);
                    OMAttribute msgAttribute = factory.createOMAttribute("code", null, "0000");
                    String msgText = "HMRC has received the " + request.getMessageType() + " document at " + this.getTime(request.getMetaData().get("GatewayTimestamp")) + ". The associated HMRCmark was: ";
                    msgText = !TPVS_message ? msgText + base32mark + ". We strongly recommend that you keep this receipt electronically, and we advise that you also keep your submission electronically for your records. They are evidence of the information that you submitted to HMRC." : msgText + "THIS IS A TEST NOTE: NO SUBMISSION HAS BEEN MADE - This submission would have been successfully processed if sent under non-test conditions.";
                    message.addAttribute(msgAttribute);
                    message.addChild((OMNode)factory.createOMText(msgText));
                    response.addSuccessResponse("hmrcmark", (OMNode)hmrcMarkReceipt);
                }
                payload = request.getOriginalPayloadInputStream();
                String correctMark = calc.createMark(payload, null);
                String msgText = "The supplied HMRCmark is incorrect.";
                this.logger.audit(request.getValidationNamespace() + "\t" + request.getMetaData().get("CorrelationID") + "\t" + msgText);
                this.logger.audit(request.getValidationNamespace() + "\t" + request.getMetaData().get("CorrelationID") + "\tINCORRECT HMRCMARK. EXPECTED: " + correctMark + " ACTUAL: " + hmrcMark);
                OMNode error = OMElementUtils.getErrorNode("2021", "business", msgText, "HMRCmark");
                response.addError("hmrcmark", error);
            }
            catch (Exception e) {
                throw new LTSSystemException(e);
            }
        } else {
            this.logger.audit(request.getValidationNamespace() + "\t" + request.getMetaData().get("CorrelationID") + "\tThere is no HMRCMark found in the payload.");
            isValid = this.noIRMarkError(response);
        }
        return isValid;
    }

    protected String getTime(String datetime) {
        SimpleDateFormat sdfDate = new SimpleDateFormat("HH.mm 'on' dd/MM/yyyy");
        String time = "";
        String newDateTime = "";
        try {
            if (datetime.indexOf("T") != -1) {
                newDateTime = datetime.replace("T", " ");
            }
            Timestamp timestamp = Timestamp.valueOf(newDateTime);
            time = sdfDate.format(timestamp);
        }
        catch (Exception e) {
            this.logger.audit("Invaid date supplied " + datetime);
            time = sdfDate.format(new Date());
        }
        return time;
    }

    protected boolean noIRMarkError(LTSResponse response) {
        String msgText = "HMRCmark not found.";
        this.logger.audit(msgText);
        OMNode error = OMElementUtils.getErrorNode("2022", "business", msgText, "HMRCmark");
        response.addError("hmrcmark", error);
        return false;
    }
}

