/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.requesthandlers;

import uk.gov.hmrc.aspire.lts.LTSSystemException;
import uk.gov.hmrc.aspire.lts.model.LTSRequest;
import uk.gov.hmrc.aspire.lts.model.LTSResponse;

public abstract class HandlerChain {
    private boolean exitOnError = false;
    private HandlerChain next = null;

    public static HandlerChain getChain(String[][] classNames) {
        HandlerChain firstHandler = null;
        try {
            if (classNames != null && classNames.length > 0) {
                Object obj = Class.forName(classNames[0][0]).newInstance();
                if (!(obj instanceof HandlerChain)) {
                    throw new LTSSystemException("Handler " + classNames[0][0] + " is not a HandlerChain");
                }
                firstHandler = (HandlerChain)obj;
            } else {
                throw new LTSSystemException("No handlers to load. Please ensure required handlers are specified in the Configuration file for the message being processed.");
            }
            boolean exitFlag = Boolean.valueOf(classNames[1][0]);
            firstHandler.setExitOnError(exitFlag);
        }
        catch (Exception e) {
            throw new LTSSystemException("Error instantiating processing handlers. ", e);
        }
        HandlerChain prev = firstHandler;
        HandlerChain curr = null;
        int n = classNames[0].length;
        for (int i = 1; i < n; ++i) {
            String handler = classNames[0][i];
            try {
                Object obj = Class.forName(handler).newInstance();
                if (!(obj instanceof HandlerChain)) {
                    throw new LTSSystemException("Handler " + handler + " is not a HandlerChain");
                }
                curr = (HandlerChain)obj;
                boolean exitFlag = Boolean.valueOf(classNames[1][i]);
                curr.setExitOnError(exitFlag);
            }
            catch (Exception e) {
                throw new LTSSystemException("Error creating handlers.", e);
            }
            prev.setNext(curr);
            prev = curr;
        }
        return firstHandler;
    }

    private void setNext(HandlerChain nextMember) {
        this.next = nextMember;
    }

    private void setExitOnError(boolean exitOnError) {
        this.exitOnError = exitOnError;
    }

    public final void process(LTSRequest ltsRequest, LTSResponse ltsResponse) throws Exception {
        boolean isPass = this.handleRequest(ltsRequest, ltsResponse);
        if (this.next != null && (isPass || !this.exitOnError)) {
            this.next.process(ltsRequest, ltsResponse);
        }
    }

    protected abstract boolean handleRequest(LTSRequest var1, LTSResponse var2) throws Exception;
}

