/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.requesthandlers;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import uk.gov.hmrc.aspire.esps.lts.logger.AuditLogger;
import uk.gov.hmrc.aspire.esps.lts.logger.LoggerFactory;
import uk.gov.hmrc.aspire.lts.LTSSystemException;
import uk.gov.hmrc.aspire.lts.model.LTSRequest;
import uk.gov.hmrc.aspire.lts.model.LTSResponse;
import uk.gov.hmrc.aspire.lts.requesthandlers.HandlerChain;
import uk.gov.hmrc.aspire.lts.requesthandlers.vat.BusinessRulesData;
import uk.gov.hmrc.aspire.lts.requesthandlers.vat.BusinessRulesTemplate;
import uk.gov.hmrc.aspire.lts.requesthandlers.vat.VATResponseData;
import uk.gov.hmrc.aspire.lts.spox.VATListener;
import uk.gov.hmrc.aspire.lts.utils.ConfigReader;
import uk.gov.hmrc.aspire.lts.utils.Constants;
import uk.gov.hmrc.aspire.lts.utils.OMElementUtils;
import uk.gov.hmrc.chris.spox.Listener;
import uk.gov.hmrc.chris.spox.XMLHandler;

public class InfoHandler
extends HandlerChain {
    private AuditLogger logger = LoggerFactory.getAuditLogger();
    private static final String PS = Constants.PATH_SEPARATOR;
    private static final String LTS_ROOT = Constants.LTS_ROOT;
    private static final String WS_CONFIG_DIR = LTS_ROOT + PS + "resources" + PS + "config" + PS + "NonConfigurable";
    private static final String PN_CONFIG_FILE = "VATPNConfig.xml";
    private static final String IN_CONFIG_FILE = "VATINConfig.xml";
    private static final String ERR_CONFIG_FILE = "VATERRConfig.xml";
    private static final String IND_CONFIG_FILE = "VATIndConfig.xml";
    private BusinessRulesData brData;
    private VATResponseData vatData;
    private BusinessRulesTemplate br;

    @Override
    protected boolean handleRequest(LTSRequest request, LTSResponse response) {
        this.logger.audit(request.getValidationNamespace() + "\t" + request.getMetaData().get("CorrelationID") + "\tValidating payload - Warning/Information handler for VAT.");
        ConfigReader pnReader = new ConfigReader(WS_CONFIG_DIR + PS + PN_CONFIG_FILE);
        Properties pnConfig = null;
        try {
            pnConfig = pnReader.getConfig();
        }
        catch (Exception exc) {
            throw new LTSSystemException("Error reading config file - " + WS_CONFIG_DIR + PS + PN_CONFIG_FILE, exc);
        }
        ConfigReader inReader = new ConfigReader(WS_CONFIG_DIR + PS + IN_CONFIG_FILE);
        Properties inConfig = null;
        try {
            inConfig = inReader.getConfig();
        }
        catch (Exception exc) {
            throw new LTSSystemException("Error reading config file - " + WS_CONFIG_DIR + PS + IN_CONFIG_FILE, exc);
        }
        ConfigReader errReader = new ConfigReader(WS_CONFIG_DIR + PS + ERR_CONFIG_FILE);
        Properties errConfig = null;
        try {
            errConfig = errReader.getConfig();
        }
        catch (Exception exc) {
            throw new LTSSystemException("Error reading config file - " + WS_CONFIG_DIR + PS + ERR_CONFIG_FILE, exc);
        }
        ConfigReader indReader = new ConfigReader(WS_CONFIG_DIR + PS + IND_CONFIG_FILE);
        Properties indConfig = null;
        try {
            indConfig = indReader.getConfig();
        }
        catch (Exception exc) {
            throw new LTSSystemException("Error reading config file - " + WS_CONFIG_DIR + PS + IND_CONFIG_FILE, exc);
        }
        try {
            this.brData = new BusinessRulesData();
            this.vatData = new VATResponseData();
            this.loaddata(request);
            HashMap inData = (HashMap)inConfig.get("xpathsMap");
            HashMap pnData = (HashMap)pnConfig.get("xpathsMap");
            HashMap errData = (HashMap)errConfig.get("xpathsMap");
            HashMap indData = (HashMap)indConfig.get("xpathsMap");
            if (errData.get(this.brData.getTraderVrn()) == null) {
                OMFactory factory = OMAbstractFactory.getOMFactory();
                OMNamespace vatNamespace = factory.createOMNamespace(this.vatData.getMessageNamespace(), this.vatData.getMessagePrefix());
                OMElement vatDeclarationResponse = factory.createOMElement("VATDeclarationResponse", vatNamespace);
                OMAttribute vatDecSchemaVersion = factory.createOMAttribute("SchemaVersion", null, this.vatData.getSchemaVersion());
                vatDeclarationResponse.addAttribute(vatDecSchemaVersion);
                OMElement header = factory.createOMElement("Header", vatNamespace, (OMContainer)vatDeclarationResponse);
                OMElement vatPeriod = factory.createOMElement("VATPeriod", vatNamespace, (OMContainer)header);
                OMElement periodId = factory.createOMElement("PeriodId", vatNamespace, (OMContainer)vatPeriod);
                periodId.addChild((OMNode)factory.createOMText(this.brData.getPeriodId()));
                if (this.brData.getPeriodStart().length() != 0) {
                    OMElement periodStartDate = factory.createOMElement("PeriodStartDate", vatNamespace, (OMContainer)vatPeriod);
                    periodStartDate.addChild((OMNode)factory.createOMText(this.brData.getPeriodStart()));
                }
                if (this.brData.getPeriodEnd().length() != 0) {
                    OMElement periodEndDate = factory.createOMElement("PeriodEndDate", vatNamespace, (OMContainer)vatPeriod);
                    periodEndDate.addChild((OMNode)factory.createOMText(this.brData.getPeriodEnd()));
                }
                OMElement currencyCode = factory.createOMElement("CurrencyCode", vatNamespace, (OMContainer)header);
                currencyCode.addChild((OMNode)factory.createOMText(this.brData.getCurrencyCode()));
                OMElement body = factory.createOMElement("Body", vatNamespace, (OMContainer)vatDeclarationResponse);
                OMElement paymentDueDate = factory.createOMElement("PaymentDueDate", vatNamespace, (OMContainer)body);
                paymentDueDate.addChild((OMNode)factory.createOMText("2009-01-01"));
                OMElement vatDeclarationReference = factory.createOMElement("VATDeclarationReference", vatNamespace, (OMContainer)body);
                vatDeclarationReference.addChild((OMNode)factory.createOMText(this.brData.getTraderVrn()));
                OMElement receiptTimestamp = factory.createOMElement("ReceiptTimestamp", vatNamespace, (OMContainer)body);
                receiptTimestamp.addChild((OMNode)factory.createOMText(this.brData.getReceiptTimestamp()));
                OMElement paymentNotification = factory.createOMElement("PaymentNotification", vatNamespace, (OMContainer)body);
                OMElement paymentNarrative = factory.createOMElement("Narrative", vatNamespace, (OMContainer)paymentNotification);
                if (this.brData.getTraderVrn().equals("999123417")) {
                    paymentNarrative.addChild((OMNode)factory.createOMText((pnData.get(this.brData.getTraderVrn()) == null ? " " : (String)pnData.get(this.brData.getTraderVrn())).replace("[Value of tax due]", this.brData.getAASBalancingPayment())));
                } else {
                    paymentNarrative.addChild((OMNode)factory.createOMText((pnData.get(this.brData.getTraderVrn()) == null ? " " : (String)pnData.get(this.brData.getTraderVrn())).replace("[Value of tax due]", this.brData.getNetVat())));
                }
                OMElement netVAT = factory.createOMElement("NetVAT", vatNamespace, (OMContainer)paymentNotification);
                netVAT.addChild((OMNode)factory.createOMText(this.brData.getNetVat()));
                if (indData.get(this.brData.getTraderVrn()) != null) {
                    OMElement oMElement;
                    if (((String)indData.get(this.brData.getTraderVrn())).equals("1")) {
                        oMElement = factory.createOMElement("NilPaymentIndicator", vatNamespace, (OMContainer)paymentNotification);
                    } else if (((String)indData.get(this.brData.getTraderVrn())).equals("2")) {
                        oMElement = factory.createOMElement("RepaymentIndicator", vatNamespace, (OMContainer)paymentNotification);
                    } else if (((String)indData.get(this.brData.getTraderVrn())).equals("3")) {
                        OMElement ddPaymentStatus = factory.createOMElement("DirectDebitPaymentStatus", vatNamespace, (OMContainer)paymentNotification);
                        OMElement ddCollectionDate = factory.createOMElement("CollectionDate", vatNamespace, (OMContainer)ddPaymentStatus);
                        ddCollectionDate.addChild((OMNode)factory.createOMText("2009-01-01"));
                    } else if (((String)indData.get(this.brData.getTraderVrn())).equals("4")) {
                        OMElement paymentRequest = factory.createOMElement("PaymentRequest", vatNamespace, (OMContainer)paymentNotification);
                        OMElement vatDecResponse = factory.createOMElement("DirectDebitInstructionStatus", vatNamespace, (OMContainer)paymentRequest);
                        if (this.brData.getTraderVrn().equals("999123403")) {
                            vatDecResponse.addChild((OMNode)factory.createOMText("Direct Debit Not Set-up"));
                        }
                        if (this.brData.getTraderVrn().equals("999123404")) {
                            vatDecResponse.addChild((OMNode)factory.createOMText("Direct Debit Not Set-up"));
                        }
                        if (this.brData.getTraderVrn().equals("999123405")) {
                            vatDecResponse.addChild((OMNode)factory.createOMText("Direct Debit Not Yet Effective"));
                        }
                        if (this.brData.getTraderVrn().equals("999123406")) {
                            vatDecResponse.addChild((OMNode)factory.createOMText("Direct Debit Not Yet Effective"));
                        }
                        if (this.brData.getTraderVrn().equals("999123411")) {
                            vatDecResponse.addChild((OMNode)factory.createOMText("Direct Debit Not Set-up"));
                        }
                        if (this.brData.getTraderVrn().equals("999123412")) {
                            vatDecResponse.addChild((OMNode)factory.createOMText("Direct Debit Not Yet Effective"));
                        }
                    }
                }
                if (!this.brData.getAASBalancingPayment().equals("")) {
                    OMElement aasBalancingPayment = factory.createOMElement("AASBalancingPayment", vatNamespace, (OMContainer)paymentNotification);
                    aasBalancingPayment.addChild((OMNode)factory.createOMText((double)Float.valueOf(this.brData.getAASBalancingPayment().trim()).floatValue() > 0.0 ? this.brData.getAASBalancingPayment() : "0.00"));
                }
                if (inData.get(this.brData.getTraderVrn()) != null) {
                    OMElement informationNotification = factory.createOMElement("InformationNotification", vatNamespace, (OMContainer)body);
                    OMElement informationNarrative = factory.createOMElement("Narrative", vatNamespace, (OMContainer)informationNotification);
                    informationNarrative.addChild((OMNode)factory.createOMText((String)inData.get(this.brData.getTraderVrn())));
                }
                OMElement extensionPart2 = factory.createOMElement("ExtensionPart", vatNamespace, (OMContainer)body);
                response.addSuccessResponse("vatResponse", (OMNode)vatDeclarationResponse);
            } else {
                String msgText = ((String)errData.get(this.brData.getTraderVrn())).replace("[PeriodID]", this.brData.getPeriodId());
                this.logger.audit(request.getValidationNamespace() + "\t" + request.getMetaData().get("CorrelationID") + "\t + VRN:" + this.brData.getTraderVrn());
                OMNode error = this.brData.getTraderVrn().equals("999123407") ? OMElementUtils.getErrorNode("8507", "business", msgText, "vat:periodID") : (this.brData.getTraderVrn().equals("999123408") ? OMElementUtils.getErrorNode("8508", "business", msgText, "vat:VRN") : (this.brData.getTraderVrn().equals("999123409") ? OMElementUtils.getErrorNode("8506", "business", msgText, "vat:periodID") : OMElementUtils.getErrorNode("0000", "business", msgText, "unknown")));
                response.addError("irmark", error);
            }
        }
        catch (Exception e) {
            throw new LTSSystemException(e);
        }
        return true;
    }

    private void loaddata(LTSRequest request) {
        try {
            InputStream payload = request.getPayloadInputStream();
            VATListener vatListener = new VATListener();
            XMLHandler handler = new XMLHandler(new Listener[]{vatListener});
            handler.readXML(payload);
            this.brData.setAASBalancingPayment(vatListener.getAasBalancingPayment());
            this.brData.setCurrencyCode(vatListener.getDefaultCurrency());
            this.brData.setNetECSupplies(vatListener.getNetECSupplies());
            this.brData.setNetVat(vatListener.getNetVAT());
            this.brData.setPeriodEnd(vatListener.getPeriodEnd());
            this.brData.setPeriodId(vatListener.getperiodID());
            this.brData.setPeriodStart(vatListener.getPeriodStart());
            this.brData.setReceiptTimestamp(request.getMetaData().get("GatewayTimestamp"));
            this.brData.setTotalVat(vatListener.getTotalVAT());
            this.brData.setTraderVrn(vatListener.getTraderVRN());
            this.brData.setVatReclaimedOnInputs(vatListener.getVatReclaimedOnInputs());
            this.vatData.setGatewayTimestamp(vatListener.getGatewayTimestamp());
            this.vatData.setSchemaVersion(vatListener.getSchemaVersion());
            this.vatData.setNetVat(vatListener.getNameSpaceMap());
            this.vatData.setMessageNamespace(vatListener.getMessageNamespace());
            this.vatData.setPrefix(vatListener.getMessagePrefix());
        }
        catch (Exception e) {
            throw new LTSSystemException(e);
        }
    }
}

