/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.requesthandlers;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import paye.channel.SubmissionChannel;
import subproc.SubmissionValidatorFactory;
import subproc.params.PAYEValidationParams;
import subproc.result.PAYEValidationResult;
import uk.gov.hmrc.aspire.esps.lts.logger.AuditLogger;
import uk.gov.hmrc.aspire.esps.lts.logger.LoggerFactory;
import uk.gov.hmrc.aspire.lts.LTSSystemException;
import uk.gov.hmrc.aspire.lts.model.LTSRequest;
import uk.gov.hmrc.aspire.lts.model.LTSResponse;
import uk.gov.hmrc.aspire.lts.requesthandlers.HandlerChain;
import uk.gov.hmrc.aspire.lts.spox.ValidationErrorsListener;
import uk.gov.hmrc.chris.spox.Listener;
import uk.gov.hmrc.chris.spox.XMLHandler;

public class PAYEEoYValidationHandler
extends HandlerChain {
    private AuditLogger logger = LoggerFactory.getAuditLogger();

    @Override
    protected boolean handleRequest(LTSRequest ltsRequest, LTSResponse ltsResponse) {
        this.logger.audit(ltsRequest.getValidationNamespace() + "\t" + ltsRequest.getMetaData().get("CorrelationID") + "\tValidating PAYE payload - Schema and Business Rules");
        boolean isValid = false;
        InputStream payload = ltsRequest.getPayloadInputStream();
        try {
            PAYEValidationParams params = new PAYEValidationParams();
            params.setTaxYear(ltsRequest.getAttribute("TaxYear"));
            params.setMaxErrors(-1);
            params.setOutputDeveloperMessages(true);
            params.setInjectMISResultIntoResponse(false);
            params.getResponseParams().setGenerateGovTalkEnvelope(false);
            params.setToleranceCheckRequired(false);
            Map<String, String> metadata = ltsRequest.getMetaData();
            String paperIndicator = metadata.get("isPaper");
            if (paperIndicator != null) {
                params.setChannel(SubmissionChannel.Paper);
            }
            ByteArrayOutputStream responseStream = new ByteArrayOutputStream();
            BufferedReader validatorInput = new BufferedReader(new InputStreamReader(payload));
            BufferedWriter validatorOutput = new BufferedWriter(new OutputStreamWriter((OutputStream)responseStream, "UTF-8"));
            PAYEValidationResult result = SubmissionValidatorFactory.getInstance().validateSubmission((Reader)validatorInput, (Writer)validatorOutput, params);
            int QS2result = result.getQS2Result().getErrorCount();
            int QS3result = result.getQS3Result().getErrorCount();
            List errors = result.getProcessingErrors();
            if (QS2result == 0 && QS3result == 0) {
                ByteArrayInputStream bais = new ByteArrayInputStream(responseStream.toByteArray());
                XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(bais);
                StAXOMBuilder builder = new StAXOMBuilder(parser);
                OMElement successResponseMessage = builder.getDocumentElement();
                ltsResponse.setSuccessResponseMessage(successResponseMessage.getFirstElement());
                isValid = true;
            } else if (errors != null && errors.size() != 0) {
                LoggerFactory.getAuditLogger().audit("", ltsRequest.getValidationNamespace(), ltsRequest.getMetaData().get("CorrelationID"), "VALIDATION FAILURE. ERROR COUNT: " + errors.size());
                ByteArrayInputStream bais = new ByteArrayInputStream(responseStream.toByteArray());
                ValidationErrorsListener listener = new ValidationErrorsListener(ltsResponse);
                XMLHandler handler = new XMLHandler(new Listener[]{listener});
                handler.readXML((InputStream)bais);
                isValid = false;
            }
        }
        catch (Exception e) {
            throw new LTSSystemException(e);
        }
        return isValid;
    }
}

