/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.requesthandlers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import uk.gov.hmrc.aspire.esps.lts.logger.AuditLogger;
import uk.gov.hmrc.aspire.esps.lts.logger.LoggerFactory;
import uk.gov.hmrc.aspire.esps.validator.ValidationError;
import uk.gov.hmrc.aspire.esps.validator.ValidationSummary;
import uk.gov.hmrc.aspire.esps.validator.Validator;
import uk.gov.hmrc.aspire.lts.LTSSystemException;
import uk.gov.hmrc.aspire.lts.model.LTSRequest;
import uk.gov.hmrc.aspire.lts.model.LTSResponse;
import uk.gov.hmrc.aspire.lts.requesthandlers.HandlerChain;
import uk.gov.hmrc.aspire.lts.spox.ValidationErrorsListener;
import uk.gov.hmrc.chris.spox.Listener;
import uk.gov.hmrc.chris.spox.XMLHandler;

public class ValidationHandler
extends HandlerChain {
    private AuditLogger logger = LoggerFactory.getAuditLogger();

    @Override
    protected boolean handleRequest(LTSRequest ltsRequest, LTSResponse ltsResponse) {
        this.logger.audit(ltsRequest.getValidationNamespace() + "\t" + ltsRequest.getMetaData().get("CorrelationID") + "\tValidating payload - Schema and Business Rules");
        boolean isValid = false;
        InputStream payload = ltsRequest.getPayloadInputStream();
        ByteArrayOutputStream responseStream = new ByteArrayOutputStream();
        Validator validator = new Validator();
        ValidationSummary summary = null;
        try {
            String envNamespace = ltsRequest.getConfig().getProperty("EnvelopeNamespace");
            String timeStampStr = ltsRequest.getMetaData().get("SystemTimestamp");
            if (timeStampStr != null) {
                Date submissionDate = null;
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                submissionDate = dateFormat.parse(timeStampStr);
                summary = validator.validate(envNamespace, ltsRequest.getValidationNamespace(), payload, (OutputStream)responseStream, submissionDate);
            } else {
                summary = validator.validate(envNamespace, ltsRequest.getValidationNamespace(), payload, (OutputStream)responseStream);
            }
            List errors = summary.getProcessingErrors();
            if (errors != null && errors.size() != 0) {
                LoggerFactory.getAuditLogger().audit("", ltsRequest.getValidationNamespace(), ltsRequest.getMetaData().get("CorrelationID"), ((ValidationError)errors.get(0)).getType() + " VALIDATION FAILURE. ERROR COUNT: " + errors.size());
                String validationResult = responseStream.toString("UTF-8");
                ByteArrayInputStream bais = new ByteArrayInputStream(validationResult.getBytes("UTF-8"));
                ValidationErrorsListener listener = new ValidationErrorsListener(ltsResponse);
                XMLHandler handler = new XMLHandler(new Listener[]{listener});
                handler.readXML((InputStream)bais);
                isValid = this.treatErrorTypesDifferently(errors);
            } else {
                isValid = true;
            }
        }
        catch (Exception e) {
            throw new LTSSystemException(e);
        }
        return isValid;
    }

    protected boolean treatErrorTypesDifferently(List<ValidationError> errors) {
        return false;
    }
}

