/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.requesthandlers.vat;

import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.util.Date;
import uk.gov.hmrc.aspire.lts.LTSSystemException;
import uk.gov.hmrc.aspire.lts.requesthandlers.vat.BusinessRulesData;
import uk.gov.hmrc.aspire.lts.requesthandlers.vat.Status;

public abstract class BusinessRulesTemplate {
    protected BusinessRulesData inputData;
    private boolean notEligibleForDirectDebit;
    private boolean directDebitNotYetEffective;
    private boolean directDebitNotSetup;
    private boolean directDebit;
    private boolean repayment;
    private boolean nilPayment;

    public void init(BusinessRulesData inputData) {
        this.inputData = inputData;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Status applyRules() {
        if (!this.existsVRN()) return Status.REJECTED_INVALID_TRADER_VRN;
        if (!this.isOpenPeriod()) return Status.REJECTED_INVALID_PERIOD;
        int difference = this.getPaymentIndicator();
        if (difference > 0) {
            BigDecimal balancingPayment = new BigDecimal(this.inputData.getAASBalancingPayment());
            if ((balancingPayment == null || this.isTraderSchemaAnnualAccounting()) && this.isTraderSchemaAnnualAccounting()) {
                if (this.isDDIEffective()) {
                    if (balancingPayment == null) {
                        this.inputData.setAASBalancingPayment(new BigDecimal(0).toString());
                    }
                } else if (balancingPayment != null) {
                    // empty if block
                }
            }
            if (this.existsDDI()) {
                if (this.isDDIEffective()) {
                    this.setDirectDebit(true);
                    return Status.ACCEPTED;
                } else {
                    this.setDirectDebitNotYetEffective(true);
                }
                return Status.ACCEPTED;
            } else {
                this.setDirectDebitNotSetup(true);
            }
            return Status.ACCEPTED;
        } else if (difference < 0) {
            this.setRepayment(true);
            return Status.ACCEPTED;
        } else {
            this.setNilPayment(true);
        }
        return Status.ACCEPTED;
    }

    protected int getPaymentIndicator() {
        return this.inputData.getTotalVat().compareTo(this.inputData.getVatReclaimedOnInputs());
    }

    public boolean isDirectDebit() {
        return this.directDebit;
    }

    protected void setDirectDebit(boolean directDebit) {
        this.directDebit = directDebit;
    }

    public boolean isDirectDebitNotSetup() {
        return this.directDebitNotSetup;
    }

    public boolean isDirectDebitNotYetEffective() {
        return this.directDebitNotYetEffective;
    }

    public boolean isNilPayment() {
        return this.nilPayment;
    }

    public boolean isNotEligibleForDirectDebit() {
        return this.notEligibleForDirectDebit;
    }

    public boolean isRepayment() {
        return this.repayment;
    }

    protected void setDirectDebitNotSetup(boolean directDebitNotSetup) {
        this.directDebitNotSetup = directDebitNotSetup;
    }

    protected void setDirectDebitNotYetEffective(boolean directDebitNotYetEffective) {
        this.directDebitNotYetEffective = directDebitNotYetEffective;
    }

    protected void setNilPayment(boolean nilPayment) {
        this.nilPayment = nilPayment;
    }

    protected void setNotEligibleForDirectDebit(boolean notEligibleForDirectDebit) {
        this.notEligibleForDirectDebit = notEligibleForDirectDebit;
    }

    protected void setRepayment(boolean repayment) {
        this.repayment = repayment;
    }

    public abstract boolean isPaymentDueDateExpired();

    public abstract Date getCollectionDate();

    public abstract boolean existsVRN();

    public abstract boolean isOpenPeriod();

    public abstract boolean isTraderAddressUp2Date();

    public abstract Date getPaymentDueDate();

    protected abstract boolean isTraderSchemaAnnualAccounting();

    protected abstract boolean isTraderSchemaPaymentOnAccount();

    protected abstract boolean isTraderSchemaQuarterlyStagger();

    protected abstract boolean existsDDI();

    protected abstract boolean isDDIEffective();

    public BusinessRulesData getInputData() {
        return this.inputData;
    }

    public static class Factory {
        public static BusinessRulesTemplate getInstance(String fqcn) {
            Class[] classParameters = new Class[]{};
            Object[] parameters = new Object[]{};
            try {
                Class<?> newClass = Class.forName(fqcn);
                Constructor<?> construct = newClass.getConstructor(classParameters);
                return (BusinessRulesTemplate)construct.newInstance(parameters);
            }
            catch (Exception e) {
                throw new LTSSystemException("Could not create BusinessRules using " + fqcn, e);
            }
        }
    }
}

