/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.requestprocessors;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import uk.gov.hmrc.aspire.lts.LTSException;
import uk.gov.hmrc.aspire.lts.LTSSystemException;
import uk.gov.hmrc.aspire.lts.requestprocessors.LOBConfigHolder;

public class LOBConfigReader {
    private static final String PS = System.getProperty("file.separator");
    private static final String LTS_ROOT = System.getProperty("lts.root");
    private static final String WS_CONFIG_DIR = LTS_ROOT + PS + "resources" + PS + "config" + PS + "NonConfigurable";
    private static Map<String, LOBConfigHolder> lobConfigMap = new HashMap<String, LOBConfigHolder>();
    private static final LOBConfigReader INSTANCE = new LOBConfigReader();
    private static final String LOB_RECIEVER_CONFIG_FILE = "LobReceiverConfig.xml";
    private InputStream lobConfigStream = null;

    private LOBConfigReader() {
        try {
            this.processLobConfigFile();
        }
        catch (LTSException e) {
            e.printStackTrace();
        }
    }

    public static LOBConfigReader getInstance() {
        return INSTANCE;
    }

    private void processLobConfigFile() throws LTSException {
        try {
            this.loadLobConfig();
            Document lobConfigDoc = this.parseLobConfigFile();
            this.extractLOBConfigElements(lobConfigDoc);
        }
        catch (LTSSystemException e) {
            throw new LTSException("Failure to Process the LOB Config File");
        }
    }

    private void loadLobConfig() throws LTSException {
        try {
            this.lobConfigStream = new FileInputStream(WS_CONFIG_DIR + PS + LOB_RECIEVER_CONFIG_FILE);
        }
        catch (FileNotFoundException e) {
            throw new LTSException("Problem reading the LOB Config File ", (Throwable)e, null, null);
        }
    }

    private Document parseLobConfigFile() throws LTSSystemException {
        SAXBuilder builder = new SAXBuilder();
        Document lobConfigDoc = null;
        try {
            lobConfigDoc = builder.build(this.lobConfigStream);
        }
        catch (JDOMException e) {
            throw new LTSSystemException("Could not get Parser to parse LOB Config document.\n" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new LTSSystemException("Could not parse the LOB Config document.\n" + e.getMessage(), e);
        }
        return lobConfigDoc;
    }

    private void extractLOBConfigElements(Document lobConfigDoc) throws LTSException {
        Element root = lobConfigDoc.getRootElement();
        Namespace ns = root.getNamespace();
        List list = root.getChildren("LOB", ns);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String value;
            LOBConfigHolder lobConfigHolder = new LOBConfigHolder();
            Element entryNode = (Element)list.get(i);
            Element currElement = entryNode.getChild("MessageClass", ns);
            if (currElement != null) {
                value = currElement.getAttribute("name").getValue();
                if (value == null) {
                    throw new LTSException("Attribute name missing for element MessageClass in the LOB config file.");
                }
            } else {
                throw new LTSException("MessageClass is missing in the LOB Config file.");
            }
            lobConfigHolder.setMessageClass(value);
            value = currElement.getAttribute("eoy").getValue();
            if (value == null) {
                throw new LTSException("Attribute eoy missing for element MessageClass in the LOB config file.");
            }
            lobConfigHolder.setEoYInd(value);
            currElement = entryNode.getChild("ConfigFileName", ns);
            if (currElement == null) {
                throw new LTSException("ConfigFileName is missing in the LOB config file.");
            }
            lobConfigHolder.setReceiverConfigFileName(currElement.getTextTrim());
            currElement = entryNode.getChild("LoggingName", ns);
            if (currElement == null) {
                throw new LTSException("LoggingName is missing in the LOB config file.");
            }
            lobConfigHolder.setLogingName(currElement.getTextTrim());
            currElement = entryNode.getChild("StaticResponse", ns);
            if (currElement != null) {
                value = currElement.getAttribute("StaticFolder").getValue();
                if (value != null) {
                    value = value.replace("\\", System.getProperty("file.separator"));
                    lobConfigHolder.setResponseFolder(value);
                    lobConfigHolder.setStaticResponseDownload_Ind(true);
                } else {
                    throw new LTSException("Attribute StaticFolder missing for element StaticResponse in the LOB config file.");
                }
            }
            if ((currElement = entryNode.getChild("Composer", ns)) == null) {
                throw new LTSException("Composer is missing in the LOB config file.");
            }
            lobConfigHolder.setComposerName(currElement.getTextTrim());
            lobConfigMap.put(lobConfigHolder.getMessageClass(), lobConfigHolder);
        }
    }

    public LOBConfigHolder getLobConfig(String messageClass) throws LTSException {
        String lookupMessageClass = this.removeMessageClassSuffix(messageClass);
        LOBConfigHolder lobConfigHolder = null;
        lobConfigHolder = lobConfigMap.get(lookupMessageClass);
        return lobConfigHolder;
    }

    private String removeMessageClassSuffix(String messageClass) {
        String lookupMsgClass = messageClass;
        if (messageClass.contains("ATT")) {
            lookupMsgClass = lookupMsgClass.substring(0, messageClass.lastIndexOf("-ATT"));
        } else if (messageClass.contains("TIL")) {
            lookupMsgClass = lookupMsgClass.substring(0, messageClass.lastIndexOf("-TIL"));
        } else if (messageClass.contains("ATT-TIL")) {
            lookupMsgClass = lookupMsgClass.substring(0, messageClass.lastIndexOf("-ATT-TIL"));
        }
        return lookupMsgClass;
    }
}

