/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.requestprocessors;

import org.apache.commons.fileupload.FileItem;
import uk.gov.hmrc.aspire.lts.LTSException;
import uk.gov.hmrc.aspire.lts.receiver.GovTalkLOBMessageReceiver;
import uk.gov.hmrc.aspire.lts.requestprocessors.LOBConfigHolder;
import uk.gov.hmrc.aspire.lts.requestprocessors.LOBConfigReader;
import uk.gov.hmrc.aspire.lts.spox.GovTalkListener;
import uk.gov.hmrc.aspire.lts.utils.Constants;
import uk.gov.hmrc.aspire.lts.utils.MessageResponse;
import uk.gov.hmrc.chris.spox.Listener;
import uk.gov.hmrc.chris.spox.XMLHandler;

public class LTSRequestController {
    private static final String PS = Constants.PATH_SEPARATOR;
    private static final String LTS_ROOT = Constants.LTS_ROOT;
    private static final String WS_CONFIG_DIR = LTS_ROOT + PS + "resources" + PS + "config" + PS + "NonConfigurable";
    private LOBConfigReader lobConfigReader = null;

    public MessageResponse routeRequest(FileItem fileItem, String ... taxYear) throws LTSException {
        String messageNamespace;
        String messageClass;
        MessageResponse response = new MessageResponse();
        try {
            GovTalkListener govTalkListener = new GovTalkListener();
            XMLHandler handler = new XMLHandler(new Listener[]{govTalkListener});
            handler.readXML(fileItem.getInputStream());
            messageClass = govTalkListener.getMessageClass();
            messageNamespace = govTalkListener.getMessageNamespace();
        }
        catch (Exception e) {
            throw new LTSException("File of wrong type, please select correct file", (Throwable)e, null, null);
        }
        this.lobConfigReader = LOBConfigReader.getInstance();
        LOBConfigHolder lobConfigHolder = this.lobConfigReader.getLobConfig(messageClass);
        if (taxYear == null || taxYear.length == 0) {
            response.setOMResponse(new GovTalkLOBMessageReceiver().processRequest(fileItem, messageNamespace, messageClass, lobConfigHolder, new String[0]));
        } else if (lobConfigHolder == null || !lobConfigHolder.getEoYInd()) {
            response.setOMResponse(new GovTalkLOBMessageReceiver().processRequest(fileItem, messageNamespace, messageClass, lobConfigHolder, taxYear));
        }
        return response;
    }
}

