/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.requestprocessors;

import com.decisionsoft.rim.calc.CalculationValidator;
import com.decisionsoft.rim.calc.CalculationValidatorException;
import com.decisionsoft.rim.calc.CalculationValidatorFactory;
import com.decisionsoft.rim.calc.InvalidNamespaceException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.fileupload.FileItem;
import org.jdom.Document;
import uk.gov.hmrc.aspire.esps.common.metadata.MetaDataException;
import uk.gov.hmrc.aspire.esps.lts.logger.LoggerFactory;
import uk.gov.hmrc.aspire.esps.validator.ValidationError;
import uk.gov.hmrc.aspire.esps.validator.ValidationSummary;
import uk.gov.hmrc.aspire.esps.validator.Validator;
import uk.gov.hmrc.aspire.esps.validator.config.Configuration;
import uk.gov.hmrc.aspire.esps.validator.config.ServiceNotRegisteredException;
import uk.gov.hmrc.aspire.lts.LTSException;
import uk.gov.hmrc.aspire.lts.irmark.IRMarkCalc;
import uk.gov.hmrc.aspire.lts.requestprocessors.SubmissionMetaData;
import uk.gov.hmrc.aspire.lts.responder.IrmarkStatus;
import uk.gov.hmrc.aspire.lts.responder.Responder;
import uk.gov.hmrc.aspire.lts.responder.ResponseData;

public class RequestProcessor {
    protected static final String stylesheetFilename = System.getProperty("responder.config.xsltStylesheet");
    protected static final String envelopeFlag = System.getProperty("responder.config.generateEnvelope");
    boolean zeroErrors = true;

    protected static final int countCalculationErrors(String response) {
        int index = 0;
        int count = 0;
        while ((index = response.indexOf("<err:Error>", index)) > -1) {
            ++count;
            ++index;
        }
        return count;
    }

    public Document processRequest(FileItem fileItem, String remoteHost, StringBuffer requestURL) throws LTSException {
        String correlationId;
        String namespaceURI;
        SubmissionMetaData metaData;
        IrmarkStatus irMarkStatusResult;
        boolean validationSuccessStatus;
        boolean irMarkCheckResult;
        String saCalculationResult;
        String validationResult;
        block35: {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            validationResult = null;
            saCalculationResult = null;
            irMarkCheckResult = false;
            validationSuccessStatus = true;
            irMarkStatusResult = null;
            if (stylesheetFilename == null || stylesheetFilename.trim().length() == 0) {
                System.err.println("Required System property 'responder.config.xsltStylesheet' is missing or empty");
                throw new LTSException("Required System property 'responder.config.xsltStylesheet' is missing or empty", null, null);
            }
            if (envelopeFlag == null || envelopeFlag.trim().length() == 0) {
                System.err.println("Required System property 'responder.config.generateEnvelope' is missing or empty");
                throw new LTSException("Required System property 'responder.config.generateEnvelope' is missing or empty", null, null);
            }
            metaData = null;
            try {
                metaData = new SubmissionMetaData(fileItem.getInputStream());
            }
            catch (MetaDataException mde) {
                throw new LTSException("File of wrong type, please select correct file", (Throwable)mde, null, null);
            }
            catch (IOException ioe) {
                throw new LTSException(ioe, null, null);
            }
            namespaceURI = metaData.getValue("IRenvelope");
            correlationId = metaData.getValue("CorrelationID");
            String timestampStr = metaData.getValue("Timestamp");
            try {
                LoggerFactory.getAuditLogger().audit(remoteHost, namespaceURI, correlationId, "RECEIVED VIA FILE UPLOAD REQUEST");
                String valType = String.valueOf(Configuration.getValidationType((String)namespaceURI));
                if (!valType.equals("null")) {
                    LoggerFactory.getAuditLogger().audit(remoteHost, namespaceURI, correlationId, "PERFORMING " + valType + " VALIDATION");
                }
                Date submissionDate = null;
                if (timestampStr != null) {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                    submissionDate = df.parse(timestampStr);
                }
                Validator validator = new Validator();
                ValidationSummary summary = validator.validate("http://www.govtalk.gov.uk/CM/envelope", namespaceURI, fileItem.getInputStream(), (OutputStream)baos, submissionDate);
                validationResult = baos.toString("UTF-8");
                List errors = summary.getProcessingErrors();
                if (errors != null && errors.size() > 0) {
                    this.zeroErrors = false;
                    validationSuccessStatus = false;
                    LoggerFactory.getAuditLogger().audit(remoteHost, namespaceURI, correlationId, ((ValidationError)errors.get(0)).getType() + " VALIDATION FAILURE. ERROR COUNT: " + errors.size());
                } else {
                    LoggerFactory.getAuditLogger().audit(remoteHost, namespaceURI, correlationId, "VALIDATION COMPLETE");
                }
            }
            catch (ServiceNotRegisteredException snre) {
                if (snre.getMessage() != null) {
                    throw new LTSException("The LTS has not been configured with the necessary Artefacts to service submissions of type: " + snre.getMessage(), (Throwable)snre, namespaceURI, correlationId);
                }
                throw new LTSException("Invalid XML submission - missing namespace URI for element \"IRenvelope\"", (Throwable)snre, namespaceURI, correlationId);
            }
            catch (Exception e) {
                throw new LTSException(e, namespaceURI, correlationId);
            }
            if (this.zeroErrors) {
                try {
                    String msgClass = metaData.getValue("Class");
                    if (this.isValidatibleMsgClass(msgClass)) {
                        System.out.println("\n*********************************************************************\n");
                        System.out.println("SA Calculator version info for '" + namespaceURI + "'\n");
                        System.out.println(CalculationValidatorFactory.INSTANCE.getVersionString(namespaceURI));
                        System.out.println("\n*********************************************************************\n");
                        LoggerFactory.getAuditLogger().audit(remoteHost, namespaceURI, correlationId, "MESSAGE CLASS: " + msgClass + " BEING SENT TO SA CALCULATOR");
                        CalculationValidator calculator = CalculationValidatorFactory.INSTANCE.newInstance(namespaceURI);
                        if (calculator == null) break block35;
                        try {
                            LoggerFactory.getAuditLogger().audit(remoteHost, namespaceURI, correlationId, "CALCULATION BEING PERFORMED FOR NAMESPACE: \"" + namespaceURI + "\"...");
                            baos.reset();
                            calculator.validate(fileItem.getInputStream(), (OutputStream)baos);
                            saCalculationResult = baos.toString("UTF-8");
                            int errorCount = RequestProcessor.countCalculationErrors(saCalculationResult);
                            if (errorCount > 0) {
                                this.zeroErrors = false;
                                LoggerFactory.getAuditLogger().audit(remoteHost, namespaceURI, correlationId, "CALCULATION FAILURE. ERROR COUNT: " + errorCount);
                            } else {
                                LoggerFactory.getAuditLogger().audit(remoteHost, namespaceURI, correlationId, "CALCULATION COMPLETE");
                            }
                            break block35;
                        }
                        catch (IOException ioe) {
                            throw new LTSException(ioe, namespaceURI, correlationId);
                        }
                        catch (InvalidNamespaceException insEx) {
                            throw new LTSException("An Invalid Namespace Has Been Provided", (Throwable)insEx, namespaceURI, correlationId);
                        }
                        catch (CalculationValidatorException cve) {
                            throw new LTSException(cve, namespaceURI, correlationId);
                        }
                    }
                    LoggerFactory.getAuditLogger().audit(remoteHost, namespaceURI, correlationId, "MESSAGE CLASS: " + msgClass + " NOT SENT TO SA CALCULATOR");
                }
                catch (InvalidNamespaceException msgClass) {
                    // empty catch block
                }
            }
        }
        if (this.zeroErrors) {
            try {
                if (metaData.getValue("IRmark") != null) {
                    LoggerFactory.getAuditLogger().audit(remoteHost, namespaceURI, correlationId, "IRMARK VALIDATION BEING PERFORMED...");
                    IRMarkCalc irMarkCalc = new IRMarkCalc();
                    irMarkCheckResult = irMarkCalc.checkMark(fileItem.getInputStream(), namespaceURI, metaData.getValue("IRmark"));
                    if (irMarkCheckResult) {
                        irMarkStatusResult = IrmarkStatus.validIrmark;
                        LoggerFactory.getAuditLogger().audit("VALID IRMARK ");
                    }
                    if (!irMarkCheckResult) {
                        String expectedIRMark = irMarkCalc.getMark(fileItem.getInputStream(), namespaceURI);
                        irMarkStatusResult = IrmarkStatus.invalidIrmark;
                        LoggerFactory.getAuditLogger().audit("Invalid IRMARK ");
                        LoggerFactory.getAuditLogger().audit(remoteHost, namespaceURI, correlationId, "INCORRECT IRMARK. EXPECTED: " + expectedIRMark + " ACTUAL: " + metaData.getValue("IRmark"));
                    }
                    LoggerFactory.getAuditLogger().audit(remoteHost, namespaceURI, correlationId, "IRMARK VALIDATION COMPLETE");
                } else {
                    irMarkStatusResult = IrmarkStatus.noIrmark;
                    LoggerFactory.getAuditLogger().audit("NO IRMARK ");
                    LoggerFactory.getAuditLogger().audit(remoteHost, namespaceURI, correlationId, "NO IRMARK FOUND");
                }
            }
            catch (Exception e) {
                throw new LTSException(e, namespaceURI, correlationId);
            }
        }
        try {
            ResponseData responseData = new ResponseData();
            responseData.setEnvelopeRequired(Boolean.valueOf(envelopeFlag));
            responseData.setXsltStylesheet(new File(stylesheetFilename));
            responseData.setResponseEndPoint(requestURL.toString());
            responseData.setCorrelationId(correlationId);
            responseData.setMessageClass(metaData.getValue("Class"));
            responseData.setTransactionId(metaData.getValue("TransactionID"));
            responseData.setValidationResult(validationResult);
            responseData.setValidationStatus(validationSuccessStatus);
            if (saCalculationResult != null && saCalculationResult.length() > 0 && saCalculationResult.trim().length() > 0) {
                responseData.setSaCalculationResult(saCalculationResult);
            }
            if (this.zeroErrors && metaData.getValue("IRmark") != null) {
                String namespaceSubstring = namespaceURI.substring("http://www.govtalk.gov.uk/taxation/".length());
                String[] formDetails = namespaceSubstring.split("/");
                responseData.setIRMark(metaData.getValue("IRmark"));
                responseData.setIrmarkStatus(irMarkStatusResult);
                responseData.setFormName(formDetails[1]);
                responseData.setUTR(metaData.getValue("UTR"));
            }
            if (this.zeroErrors && metaData.getValue("IRmark") == null) {
                responseData.setIrmarkStatus(irMarkStatusResult);
            }
            new Responder();
            Document response = Responder.createResponse(responseData);
            LoggerFactory.getAuditLogger().audit(remoteHost, namespaceURI, correlationId, "RESPONDED");
            return response;
        }
        catch (Exception e) {
            throw new LTSException(e, namespaceURI, correlationId);
        }
    }

    private boolean isValidatibleMsgClass(String msgClass) {
        boolean isValidatible = false;
        StringTokenizer tokenizer = new StringTokenizer("HMRC-SA-SA100,HMRC-SA-SA100-TIL,HMRC-SA-SA100-ATT,HMRC-SA-SA100-ATT-TIL", ",");
        String thisToken = null;
        while (tokenizer.hasMoreTokens() && !isValidatible) {
            thisToken = tokenizer.nextToken();
            if (!msgClass.equalsIgnoreCase(thisToken)) continue;
            isValidatible = true;
        }
        return isValidatible;
    }
}

