/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.responder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Content;
import org.jdom.DefaultJDOMFactory;
import org.jdom.Document;
import org.jdom.Element;
import uk.gov.hmrc.aspire.lts.responder.ResponderException;
import uk.gov.hmrc.aspire.lts.responder.ResponseBuilder;

public class CompositeBuilder
implements ResponseBuilder {
    private String rootElementName;
    private List<ResponseBuilder> builders;

    public CompositeBuilder(String rootElement) {
        if (rootElement == null) {
            throw new NullPointerException("rootElement");
        }
        this.rootElementName = rootElement;
    }

    @Override
    public void add(ResponseBuilder builder) {
        if (this.builders == null) {
            this.builders = new ArrayList<ResponseBuilder>(2);
        }
        this.builders.add(builder);
    }

    @Override
    public Document build() throws ResponderException {
        Element rootElement = new Element(this.rootElementName);
        if (this.builders != null) {
            for (ResponseBuilder currBuilder : this.builders) {
                Document currDoc = currBuilder.build();
                if (currDoc == null) continue;
                rootElement.addContent((Content)((Element)currDoc.getRootElement().clone()));
            }
        }
        return new DefaultJDOMFactory().document(rootElement);
    }

    @Override
    public Iterator<ResponseBuilder> getChildren() {
        return this.builders != null ? this.builders.iterator() : null;
    }
}

