/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.responder;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.jdom.Content;
import org.jdom.DefaultJDOMFactory;
import org.jdom.Document;
import org.jdom.Element;
import uk.gov.hmrc.aspire.lts.responder.ResponderException;
import uk.gov.hmrc.aspire.lts.responder.ResponseBuilder;
import uk.gov.hmrc.aspire.lts.responder.ResponseData;

public class EnvelopeBuilder
implements ResponseBuilder {
    public static final String DEFAULT_CORRELATION_ID = "11223344556677889900";
    public static final String ROOT_ELEMENT = "Envelope";
    public static final String CORRELATION_ID_ELEMENT = "CorrelationID";
    public static final String CLASS_ELEMENT = "Class";
    public static final String TIMESTAMP_ELEMENT = "GatewayTimestamp";
    public static final String RESPONSE_END_POINT_ELEMENT = "ResponseEndPoint";
    public static final String TRANSACTION_ID_ELEMENT = "TransactionID";
    private static final String TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private List<ResponseBuilder> mainMessageBuilders;
    private ResponseData responseData;

    public EnvelopeBuilder(ResponseData responseData) {
        if (responseData == null) {
            throw new NullPointerException("responseData");
        }
        this.responseData = responseData;
    }

    @Override
    public void add(ResponseBuilder builder) {
        if (this.mainMessageBuilders == null) {
            this.mainMessageBuilders = new ArrayList<ResponseBuilder>(2);
        }
        this.mainMessageBuilders.add(builder);
    }

    @Override
    public Document build() throws ResponderException {
        Element rootElement = new Element(ROOT_ELEMENT);
        Element currElement = new Element(CLASS_ELEMENT);
        if (this.responseData.getMessageClass() != null) {
            currElement.setText(this.responseData.getMessageClass());
        }
        rootElement.addContent((Content)currElement);
        currElement = new Element(CORRELATION_ID_ELEMENT);
        if (this.responseData.getCorrelationId() != null) {
            currElement.setText(this.responseData.getCorrelationId());
        } else {
            currElement.setText(DEFAULT_CORRELATION_ID);
        }
        rootElement.addContent((Content)currElement);
        currElement = new Element(TIMESTAMP_ELEMENT);
        try {
            currElement.setText(new SimpleDateFormat(TIMESTAMP_FORMAT).format(new Date()));
        }
        catch (IllegalArgumentException iae) {
            currElement.setText("!!Formatting Error - " + iae.getMessage() + "!!");
        }
        rootElement.addContent((Content)currElement);
        currElement = new Element(RESPONSE_END_POINT_ELEMENT);
        if (this.responseData.getResponseEndPoint() != null) {
            currElement.setText(this.responseData.getResponseEndPoint());
        }
        rootElement.addContent((Content)currElement);
        currElement = new Element(TRANSACTION_ID_ELEMENT);
        if (this.responseData.getTransactionId() != null) {
            currElement.setText(this.responseData.getTransactionId());
        }
        rootElement.addContent((Content)currElement);
        if (this.mainMessageBuilders != null) {
            for (ResponseBuilder currBuilder : this.mainMessageBuilders) {
                Document doc = currBuilder.build();
                if (doc == null) continue;
                rootElement.addContent((Content)((Element)doc.getRootElement().clone()));
            }
        }
        return new DefaultJDOMFactory().document(rootElement);
    }

    @Override
    public Iterator<ResponseBuilder> getChildren() {
        return this.mainMessageBuilders != null ? this.mainMessageBuilders.iterator() : null;
    }
}

