/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.responder;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import org.jdom.Content;
import org.jdom.DefaultJDOMFactory;
import org.jdom.Document;
import org.jdom.Element;
import uk.gov.hmrc.aspire.lts.irmark.IRMarkCalc;
import uk.gov.hmrc.aspire.lts.responder.IrmarkStatus;
import uk.gov.hmrc.aspire.lts.responder.ResponderException;
import uk.gov.hmrc.aspire.lts.responder.ResponseBuilder;
import uk.gov.hmrc.aspire.lts.responder.ResponseData;

public class IRMarkMessageBuilder
implements ResponseBuilder {
    public static final String ROOT_ELEMENT = "IRMarkDetails";
    public static final String VALID_ATTRIBUTE = "valid";
    public static final String CLASS_ELEMENT = "Class";
    public static final String CURRENT_TIMESTAMP_ELEMENT = "CurrentTimestamp";
    public static final String FORM_NAME_ELEMENT = "FormName";
    public static final String SERVICE_NAME_ELEMENT = "ServiceName";
    public static final String IR_MARK_ELEMENT = "IRmark";
    public static final String IR_MARK_HUMAN_READABLE_ELEMENT = "IRmarkHumanReadable";
    public static final String UTR_ELEMENT = "UTR";
    private ResponseData responseData;

    public IRMarkMessageBuilder(ResponseData responseData) {
        if (responseData == null) {
            throw new NullPointerException("summary");
        }
        this.responseData = responseData;
    }

    @Override
    public void add(ResponseBuilder builder) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(this.getClass().getName() + ".add(" + ResponseBuilder.class.getName() + ")");
    }

    @Override
    public Document build() throws ResponderException {
        Element rootElement = new Element(ROOT_ELEMENT);
        if (this.responseData.getIrmarkStatus() != null && this.responseData.getIrmarkStatus().equals((Object)IrmarkStatus.validIrmark)) {
            rootElement.setAttribute(VALID_ATTRIBUTE, "true");
            Element currElement = new Element(CLASS_ELEMENT);
            if (this.responseData.getMessageClass() != null) {
                currElement.setText(this.responseData.getMessageClass());
            }
            rootElement.addContent((Content)currElement);
            currElement = new Element(CURRENT_TIMESTAMP_ELEMENT);
            currElement.setText(new SimpleDateFormat("HH.mm 'on' dd/MM/yyyy").format(new Date()));
            rootElement.addContent((Content)currElement);
            currElement = new Element(FORM_NAME_ELEMENT);
            if (this.responseData.getFormName() != null) {
                currElement.setText(this.responseData.getFormName());
            }
            rootElement.addContent((Content)currElement);
            currElement = new Element(IR_MARK_ELEMENT);
            if (this.responseData.getIRMark() != null) {
                currElement.setText(this.responseData.getIRMark());
            }
            rootElement.addContent((Content)currElement);
            currElement = new Element(IR_MARK_HUMAN_READABLE_ELEMENT);
            if (this.responseData.getIRMark() != null) {
                byte[] rawIRMark = IRMarkCalc.decodeBase64(this.responseData.getIRMark());
                currElement.setText(IRMarkCalc.toBase32(rawIRMark));
            }
            rootElement.addContent((Content)currElement);
            if (this.responseData.getUTR() != null) {
                currElement = new Element(UTR_ELEMENT);
                currElement.setText(this.responseData.getUTR());
                rootElement.addContent((Content)currElement);
            }
        } else if (this.responseData.getIrmarkStatus() != null && this.responseData.getIrmarkStatus().equals((Object)IrmarkStatus.noIrmark)) {
            rootElement.setAttribute(VALID_ATTRIBUTE, "no-irmark-found");
        } else if (this.responseData.getIrmarkStatus() != null && this.responseData.getIrmarkStatus().equals((Object)IrmarkStatus.invalidIrmark)) {
            rootElement.setAttribute(VALID_ATTRIBUTE, "false");
        }
        return new DefaultJDOMFactory().document(rootElement);
    }

    @Override
    public Iterator<ResponseBuilder> getChildren() {
        return null;
    }
}

