/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.responder;

import java.io.File;
import org.jdom.Document;
import org.jdom.transform.XSLTransformException;
import org.jdom.transform.XSLTransformer;
import uk.gov.hmrc.aspire.lts.responder.ResponderException;
import uk.gov.hmrc.aspire.lts.responder.ResponseBuilder;
import uk.gov.hmrc.aspire.lts.responder.ResponseBuilderFactory;
import uk.gov.hmrc.aspire.lts.responder.ResponseData;

public class Responder {
    public static Document createResponse(ResponseData responseData) throws ResponderException {
        Document response = null;
        if (responseData == null) {
            throw new NullPointerException("response");
        }
        File xsltStylesheet = responseData.getXsltStylesheet();
        if (!(xsltStylesheet.exists() && xsltStylesheet.isFile() && xsltStylesheet.canRead() && xsltStylesheet.length() != 0L)) {
            throw new ResponderException("The file \"" + xsltStylesheet.getAbsolutePath() + "\" is missing, empty or inaccessible.");
        }
        ResponseBuilder builder = ResponseBuilderFactory.createBuilder(responseData);
        if (builder != null) {
            response = builder.build();
            try {
                XSLTransformer transformer = new XSLTransformer(xsltStylesheet);
                response = transformer.transform(response);
            }
            catch (XSLTransformException xslte) {
                throw new ResponderException("Unable to transform the response message", xslte);
            }
        }
        return response;
    }
}

