/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.responder;

import uk.gov.hmrc.aspire.lts.responder.CompositeBuilder;
import uk.gov.hmrc.aspire.lts.responder.EnvelopeBuilder;
import uk.gov.hmrc.aspire.lts.responder.IRMarkMessageBuilder;
import uk.gov.hmrc.aspire.lts.responder.ResponseBuilder;
import uk.gov.hmrc.aspire.lts.responder.ResponseData;
import uk.gov.hmrc.aspire.lts.responder.SACalculationMessageBuilder;
import uk.gov.hmrc.aspire.lts.responder.ValidationMessageBuilder;

public class ResponseBuilderFactory {
    public static final String ROOT_ELEMENT = "Root";

    public static ResponseBuilder createBuilder(ResponseData responseData) {
        ResponseBuilder currBuilder = null;
        EnvelopeBuilder envelope = null;
        CompositeBuilder root = null;
        if (responseData == null) {
            throw new NullPointerException("responseData");
        }
        if (responseData.isEnvelopeRequired()) {
            envelope = new EnvelopeBuilder(responseData);
            root = new CompositeBuilder(ROOT_ELEMENT);
            root.add(envelope);
        }
        if (responseData.isValidationStatus()) {
            currBuilder = new IRMarkMessageBuilder(responseData);
            if (envelope != null) {
                envelope.add(currBuilder);
            } else {
                if (root == null) {
                    root = new CompositeBuilder(ROOT_ELEMENT);
                }
                root.add(currBuilder);
            }
        }
        currBuilder = new ValidationMessageBuilder(responseData);
        if (envelope != null) {
            envelope.add(currBuilder);
        } else {
            if (root == null) {
                root = new CompositeBuilder(ROOT_ELEMENT);
            }
            root.add(currBuilder);
        }
        if (responseData.getSaCalculationResult() != null) {
            currBuilder = new SACalculationMessageBuilder(responseData);
            if (envelope != null) {
                envelope.add(currBuilder);
            } else {
                if (root == null) {
                    root = new CompositeBuilder(ROOT_ELEMENT);
                }
                root.add(currBuilder);
            }
        }
        return root;
    }
}

