/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.responder;

import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;
import uk.gov.hmrc.aspire.lts.responder.ResponderException;
import uk.gov.hmrc.aspire.lts.responder.ResponseBuilder;
import uk.gov.hmrc.aspire.lts.responder.ResponseData;

public class SACalculationMessageBuilder
implements ResponseBuilder {
    public static final String ROOT_ELEMENT = "SACalculationResult";
    private static final String ERROR_RESPONSE_START_TAG = "<err:ErrorResponse";
    private ResponseData responseData;

    public SACalculationMessageBuilder(ResponseData responseData) {
        if (responseData == null) {
            throw new NullPointerException("responseData");
        }
        this.responseData = responseData;
    }

    @Override
    public void add(ResponseBuilder builder) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(this.getClass().getName() + ".add(" + ResponseBuilder.class.getName() + ")");
    }

    @Override
    public Document build() throws ResponderException {
        Document doc = null;
        String resultXML = "<SACalculationResult>" + this.processResult() + "</SACalculationResult>";
        try {
            doc = new SAXBuilder().build((Reader)new StringReader(resultXML));
        }
        catch (Exception e) {
            throw new ResponderException("Failed to create a JDOM Document from the following XML: " + resultXML, e);
        }
        return doc;
    }

    private String processResult() throws ResponderException {
        String saCalculationResult = this.responseData.getSaCalculationResult();
        int start = saCalculationResult.indexOf(ERROR_RESPONSE_START_TAG);
        StringBuffer processedResult = new StringBuffer();
        if (start == -1) {
            throw new ResponderException("Unable extract the SA calculation results from the response XML; the response does not conform to the expected format.\nThe following XML snippets is missing from the response: \"<err:ErrorResponse\"");
        }
        processedResult.append(saCalculationResult.substring(start).replaceAll("err:", "").replaceFirst(" xmlns:err=\"http://www.govtalk.gov.uk/CM/errorresponse\"", ""));
        return processedResult.toString();
    }

    @Override
    public Iterator<ResponseBuilder> getChildren() {
        return null;
    }
}

