/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.responder;

import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;
import uk.gov.hmrc.aspire.lts.responder.ResponderException;
import uk.gov.hmrc.aspire.lts.responder.ResponseBuilder;
import uk.gov.hmrc.aspire.lts.responder.ResponseData;

public class ValidationMessageBuilder
implements ResponseBuilder {
    public static final String ROOT_ELEMENT = "ValidationResult";
    public static final String SUCCESS_RESPONSE_ELEMENT = "SuccessResponse";
    private static final String ERROR_RESPONSE_START_TAG = "<err:ErrorResponse";
    private static final String ERROR_RESPONSE_END_TAG = "</err:ErrorResponse>";
    private static final String ERROR_COUNT_START_TAG = "<rim:ErrorCount";
    private static final String ERROR_COUNT_END_TAG = "</rim:ErrorCount>";
    private ResponseData responseData;

    public ValidationMessageBuilder(ResponseData responseData) {
        if (responseData == null) {
            throw new NullPointerException("responseData");
        }
        this.responseData = responseData;
    }

    @Override
    public void add(ResponseBuilder builder) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(this.getClass().getName() + ".add(" + ResponseBuilder.class.getName() + ")");
    }

    @Override
    public Document build() throws ResponderException {
        Document doc = null;
        String resultXML = "<ValidationResult>" + this.processValidationResult() + "</ValidationResult>";
        try {
            doc = new SAXBuilder().build((Reader)new StringReader(resultXML));
        }
        catch (Exception e) {
            throw new ResponderException("Failed to create a JDOM Document from the following XML: " + resultXML, e);
        }
        return doc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String processValidationResult() throws ResponderException {
        String validationResult = this.responseData.getValidationResult();
        int start = validationResult.indexOf(ERROR_RESPONSE_START_TAG);
        int end = validationResult.indexOf(ERROR_RESPONSE_END_TAG) + ERROR_RESPONSE_END_TAG.length();
        StringBuffer processedResult = new StringBuffer();
        if (start != -1 && end != -1) {
            processedResult.append(validationResult.substring(start, end).replaceAll("err:", "").replaceAll("val:", "").replaceFirst(" xmlns:err=\"http://www.govtalk.gov.uk/CM/errorresponse\"", ""));
            start = validationResult.indexOf(ERROR_COUNT_START_TAG);
            end = validationResult.indexOf(ERROR_COUNT_END_TAG) + ERROR_COUNT_END_TAG.length();
            if (start == -1 || end == -1) throw new ResponderException("Unable extract the validation results from the response XML; the validation response does not conform to the expected format. One or more of the following expected XML snippets are missing from the validation response: \"<err:ErrorResponse\", \"</err:ErrorResponse>\", \"<rim:ErrorCount\", \"</rim:ErrorCount>\".");
            processedResult.append(validationResult.substring(start, end).replaceAll("rim:", "").replaceFirst(" xmlns:rim=\"http://www.govtalk.gov.uk/taxation/common/validation-MIS/1\"", ""));
            return processedResult.toString();
        } else {
            processedResult.append('<').append(SUCCESS_RESPONSE_ELEMENT).append(" />");
        }
        return processedResult.toString();
    }

    @Override
    public Iterator<ResponseBuilder> getChildren() {
        return null;
    }
}

