/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.servlets;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import uk.gov.hmrc.aspire.esps.common.io.NonClosableInputStream;
import uk.gov.hmrc.aspire.esps.lts.logger.LoggerFactory;
import uk.gov.hmrc.aspire.lts.LTSException;
import uk.gov.hmrc.aspire.lts.requestprocessors.LTSRequestController;
import uk.gov.hmrc.aspire.lts.utils.MessageResponse;

public class LTSPAYEEoYServlet
extends HttpServlet {
    private static final long serialVersionUID = 5766863539638771222L;
    protected static final String SUBMISSION_FILENAME_PREFIX = "RIMValidator_";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.err.println("HTTP request method 'GET' is not supported");
        PrintWriter out = response.getWriter();
        out.println("HTTP request method 'GET' is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        NonClosableInputStream in = null;
        String taxYear = null;
        FileItem fileItem = null;
        try {
            MessageResponse reqResponse;
            try {
                if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                    throw new ServletException("Request is not Multipart..");
                }
                List dataItems = null;
                DiskFileItemFactory fileItemFactory = new DiskFileItemFactory();
                fileItemFactory.setSizeThreshold(0x100000);
                ServletFileUpload fileUpload = new ServletFileUpload((FileItemFactory)fileItemFactory);
                try {
                    dataItems = fileUpload.parseRequest(request);
                }
                catch (FileUploadException fue) {
                    throw new LTSException(fue, null, null);
                }
                if (dataItems != null && dataItems.size() > 0) {
                    int n = dataItems.size();
                    for (int i = 0; i < n; ++i) {
                        FileItem currFileItem = (FileItem)dataItems.get(i);
                        if (currFileItem.getFieldName().equalsIgnoreCase("submissionFile")) {
                            fileItem = currFileItem;
                            continue;
                        }
                        if (!currFileItem.getFieldName().equalsIgnoreCase("hiddenTaxYear")) continue;
                        taxYear = currFileItem.getString();
                    }
                }
                String remoteHost = request.getRemoteHost();
                StringBuffer requestURL = request.getRequestURL();
                reqResponse = new LTSRequestController().routeRequest(fileItem, taxYear);
                response.setContentType("text/html; charset=UTF-8");
            }
            catch (Exception e) {
                this.handleException(e, request, response, true);
                if (in != null) {
                    try {
                        in.forceClose();
                    }
                    catch (IOException ioe) {
                        LoggerFactory.getAuditLogger().writeLog("Exception during stream cleanup after writing response client:");
                        PrintWriter logOut = new PrintWriter(LoggerFactory.getAuditLogger().getLogStream());
                        ioe.printStackTrace(logOut);
                    }
                }
                return;
            }
            PrintStream responseOut = null;
            try {
                try {
                    responseOut = new PrintStream((OutputStream)response.getOutputStream(), true, "UTF-8");
                }
                catch (IOException ioe) {
                    throw new LTSException(ioe, null, null);
                }
                if ("thin".equals(request.getParameter("client"))) {
                    responseOut.println("<html>");
                    responseOut.println("<head><title>Lts Validation Results</title>");
                    responseOut.println("<link rel='stylesheet' href='/LTS/resources/style/hmrc.css' type='text/css'></link>");
                    responseOut.println("<link rel='stylesheet' href='/LTS/resources/style/print.css' type='text/css' media='print'></link>");
                    responseOut.println("<link rel='stylesheet' href='/LTS/resources/style/header.css' type='text/css'></link>");
                    responseOut.println("<link rel='stylesheet' href='/LTS/resources/style/banner.css' type='text/css'></link>");
                    responseOut.println("<link rel='stylesheet' href='/LTS/resources/style/portlet.css' type='text/css'></link>");
                    responseOut.println("<link rel='stylesheet' href='/LTS/resources/style/footer.css' type='text/css'></link>");
                    responseOut.println("<link rel='stylesheet' href='/LTS/resources/style/lists.css' type='text/css'></link>");
                    responseOut.println("<link rel='stylesheet' href='/LTS/resources/style/tables.css' type='text/css'></link>");
                    responseOut.println("<link rel='stylesheet' href='/LTS/resources/style/forms.css' type='text/css'></link>");
                    responseOut.println("<link rel='stylesheet' href='/LTS/resources/style/abt.css' type='text/css'></link>");
                    responseOut.println("</head>");
                    responseOut.println("<body>");
                    responseOut.println("<div id='header'>");
                    responseOut.println("<img src='/LTS/resources/images/hmrcLogo.gif' alt='HM Revenue &amp; Customs' width='160' height='62' align='left' />");
                    responseOut.println("<div id='header-title'>Online services</div>");
                    responseOut.println("<a name='main' class='screen-reader'></a>");
                    responseOut.println("</div>");
                    responseOut.println("<div id='banner'><h1 class='no-menu'>Local Test Service</h1></div>");
                    responseOut.println("<div align='right'><font size='2'><b> <i> LTS 2018 </i> </b></font></div>");
                    responseOut.println("<div class='columns'> <div class='column'><div class='portlet no-title-bar'><div class='portlet-header'><h2>&nbsp;</h2></div> <div class='portlet-body'>");
                    responseOut.println("<form><TABLE><DIV>Validator Response</DIV><TR><TD valign='top'><textarea rows='25' cols='110'>");
                }
                Format format = Format.getPrettyFormat();
                XMLOutputter serializer = new XMLOutputter(format);
                if (reqResponse.getDocResponse() != null) {
                    serializer.output(reqResponse.getDocResponse(), (OutputStream)responseOut);
                } else if (reqResponse.getOMResponse() != null) {
                    Document responseDoc = new SAXBuilder().build((Reader)new StringReader(reqResponse.getOMResponse().toString()));
                    serializer.output(responseDoc, (OutputStream)responseOut);
                } else {
                    responseOut.println("There is no response to report. Make sure the submission is a PAYE EOY submission.");
                }
                if ("thin".equals(request.getParameter("client"))) {
                    responseOut.println("</textarea></TD></TR>");
                    responseOut.println("<TR><TD> <a href='/LTS/PAYE'>Return to upload page</a>.</TD></TR>");
                    responseOut.println("</form></TABLE></div></div></div></div></body></html>");
                }
            }
            catch (Exception e) {
                this.handleException(e, request, response, false);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.forceClose();
                }
                catch (IOException ioe) {
                    LoggerFactory.getAuditLogger().writeLog("Exception during stream cleanup after writing response client:");
                    PrintWriter logOut = new PrintWriter(LoggerFactory.getAuditLogger().getLogStream());
                    ioe.printStackTrace(logOut);
                }
            }
        }
    }

    private void handleException(Exception e, HttpServletRequest request, HttpServletResponse response, boolean redirectPossible) throws IOException {
        if (e instanceof LTSException) {
            LTSException ltse = (LTSException)e;
            LoggerFactory.getAuditLogger().audit(request.getRemoteHost(), ltse.getNamespace(), ltse.getCorrelationId(), "EXCEPTION: ");
        } else {
            LoggerFactory.getAuditLogger().audit(request.getRemoteHost(), null, null, "EXCEPTION: ");
        }
        e.printStackTrace(new PrintStream(LoggerFactory.getAuditLogger().getLogStream()));
        try {
            if (redirectPossible && "thin".equals(request.getParameter("client"))) {
                if (e.getMessage() != null) {
                    response.sendRedirect("/LTS/resources/jsp/msg.jsp?msg=" + e.getMessage());
                } else if (e.getCause() != null) {
                    response.sendRedirect("/LTS/resources/jsp/msg.jsp?msg=" + e.getCause().getMessage());
                } else {
                    response.sendRedirect("/LTS/resources/jsp/msg.jsp?msg=" + e.getClass().getName() + ": [no message]");
                }
            } else {
                response.setContentType("text/xml");
                ServletOutputStream responseOut = response.getOutputStream();
                responseOut.print("This file could not be processed. Exception message: ");
                if (e.getMessage() != null) {
                    responseOut.print(e.getMessage());
                } else if (e.getCause() != null) {
                    responseOut.print(e.getCause().getMessage());
                } else {
                    responseOut.print(e.getClass().getName() + ": [no message]");
                }
            }
        }
        catch (IOException ioe) {
            LoggerFactory.getAuditLogger().audit(request.getRemoteHost(), null, null, "Exception while trying to write previous Exception message to the response OutputStream: ");
            ioe.printStackTrace(new PrintStream(LoggerFactory.getAuditLogger().getLogStream()));
        }
    }
}

