/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.util.Streams;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import uk.gov.hmrc.aspire.esps.lts.logger.LoggerFactory;
import uk.gov.hmrc.aspire.lts.LTSException;
import uk.gov.hmrc.aspire.lts.requestprocessors.LTSRequestController;
import uk.gov.hmrc.aspire.lts.responder.ResponderException;
import uk.gov.hmrc.aspire.lts.utils.MessageResponse;

public class LTSPostServlet
extends HttpServlet {
    private static final long serialVersionUID = -1429231510958154205L;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.err.println("HTTP request method 'GET' is not supported");
        PrintWriter out = response.getWriter();
        out.println("HTTP request method 'GET' is not supported");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        MessageResponse reqResponse = null;
        FileItem fileItem = null;
        try {
            Object items = null;
            DiskFileItemFactory fileItemFactory = new DiskFileItemFactory();
            fileItemFactory.setSizeThreshold(0x100000);
            fileItem = fileItemFactory.createItem("payload", "application/xml", false, null);
            Streams.copy((InputStream)request.getInputStream(), (OutputStream)fileItem.getOutputStream(), (boolean)true);
            String remoteHost = request.getRemoteHost();
            StringBuffer requestURL = request.getRequestURL();
            String taxYear = request.getParameter("taxYear");
            if (taxYear == null || taxYear.length() == 0) {
                reqResponse = new LTSRequestController().routeRequest(fileItem, new String[0]);
            } else if (taxYear.length() > 0) {
                reqResponse = new LTSRequestController().routeRequest(fileItem, taxYear);
            }
            response.setContentType("text/html; charset=UTF-8");
            PrintStream responseOut = null;
            responseOut = new PrintStream((OutputStream)response.getOutputStream(), true, "UTF-8");
            try {
                Format format = Format.getPrettyFormat();
                XMLOutputter serializer = new XMLOutputter(format);
                if (reqResponse.getDocResponse() != null) {
                    serializer.output(reqResponse.getDocResponse(), (OutputStream)responseOut);
                } else if (reqResponse.getOMResponse() != null) {
                    Document responseDoc = new SAXBuilder().build((Reader)new StringReader(reqResponse.getOMResponse().toString()));
                    serializer.output(responseDoc, (OutputStream)responseOut);
                }
            }
            catch (IOException ioe) {
                throw new ResponderException("Unable to write out the response message", ioe);
            }
        }
        catch (LTSException ltse) {
            LoggerFactory.getAuditLogger().audit(request.getRemoteHost(), ltse.getNamespace(), ltse.getCorrelationId(), "EXCEPTION: ");
            this.handleException(ltse, request, response);
        }
        catch (Exception e) {
            LoggerFactory.getAuditLogger().audit(request.getRemoteHost(), null, null, "EXCEPTION: ");
            this.handleException(e, request, response);
        }
    }

    private void handleException(Exception e, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (e instanceof LTSException) {
            LTSException ltse = (LTSException)e;
            LoggerFactory.getAuditLogger().audit(request.getRemoteHost(), ltse.getNamespace(), ltse.getCorrelationId(), "EXCEPTION: ");
        } else {
            LoggerFactory.getAuditLogger().audit(request.getRemoteHost(), null, null, "EXCEPTION: ");
        }
        e.printStackTrace(new PrintStream(LoggerFactory.getAuditLogger().getLogStream()));
        try {
            response.getOutputStream().print("Request Failed : " + e.getMessage());
        }
        catch (IOException ioe) {
            LoggerFactory.getAuditLogger().audit(request.getRemoteHost(), null, null, "Exception while trying to write previous Exception message to the response OutputStream: ");
            ioe.printStackTrace(new PrintStream(LoggerFactory.getAuditLogger().getLogStream()));
        }
    }
}

