/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uk.gov.hmrc.aspire.esps.lts.logger.AuditLogger;
import uk.gov.hmrc.aspire.esps.lts.logger.LoggerFactory;
import uk.gov.hmrc.aspire.lts.connectors.soap.http.fault.SoapFaultCodeEnum;
import uk.gov.hmrc.aspire.lts.connectors.soap.http.fault.SoapFaultDetail;
import uk.gov.hmrc.aspire.lts.connectors.soap.http.util.SoapUtils;
import uk.gov.hmrc.aspire.lts.connectors.soap.http.util.stream.RestartableInputStream;
import uk.gov.hmrc.aspire.lts.connectors.soap.http.xmlprocessor.SoapFaultException;
import uk.gov.hmrc.aspire.lts.connectors.soap.http.xmlprocessor.SoapMessageDetails;
import uk.gov.hmrc.aspire.lts.connectors.soap.http.xmlprocessor.http.HttpSoapRequestImpl;
import uk.gov.hmrc.aspire.lts.connectors.soap.http.xmlprocessor.http.HttpSoapResponseImpl;
import uk.gov.hmrc.aspire.lts.connectors.soap.http.xmlprocessor.http.HttpSoapServletRequestImpl;
import uk.gov.hmrc.aspire.lts.connectors.soap.http.xmlprocessor.stax.StAXSoapProcessor;
import uk.gov.hmrc.aspire.lts.soap.http.delegate.emcs.DefaultHttpSoapDelegate;

public class SOAPServletFS1
extends HttpServlet
implements Servlet {
    private static final long serialVersionUID = 1L;
    private static final String INITPARAM_BODY_NS = "payload.namespace";
    private static final String INITPARAM_DELEGATE_FQCN = "delegate.fqcn";
    private static final String TEST_QUERY_STRING = "test";
    private String payloadNS;
    private String delegateFQCN;
    private static final String SERVICE_MESSAGE_TYPE = "ServiceMessageType";
    private static AuditLogger logger = LoggerFactory.getAuditLogger();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ArrayList<String> missingConfig = new ArrayList<String>(5);
        this.payloadNS = config.getInitParameter(INITPARAM_BODY_NS);
        if (this.payloadNS == null) {
            missingConfig.add(INITPARAM_BODY_NS);
        }
        this.delegateFQCN = config.getInitParameter(INITPARAM_DELEGATE_FQCN);
        if (this.delegateFQCN == null) {
            missingConfig.add(INITPARAM_DELEGATE_FQCN);
        }
        if (missingConfig.size() > 0) {
            StringBuilder msgBuff = new StringBuilder("The following init params are missing: ");
            Iterator iterator = missingConfig.iterator();
            msgBuff.append((String)iterator.next());
            while (iterator.hasNext()) {
                msgBuff.append(", ").append((String)iterator.next());
            }
            throw new UnavailableException(msgBuff.toString());
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (TEST_QUERY_STRING.equals(request.getQueryString())) {
            response.setStatus(200);
        } else {
            response.setStatus(405);
        }
    }

    protected void doPost(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        ServletInputStream inputStream = httpRequest.getInputStream();
        RestartableInputStream ris = new RestartableInputStream((InputStream)inputStream);
        StAXSoapProcessor processor = new StAXSoapProcessor();
        try {
            HttpSoapRequestImpl soapRequest = new HttpSoapRequestImpl(httpRequest, (InputStream)((Object)ris));
            SoapMessageDetails details = processor.processRequest(soapRequest);
            ris.restartStream();
            String serviceMsgType = details.getServiceMessageType();
            httpRequest.setAttribute(SERVICE_MESSAGE_TYPE, (Object)serviceMsgType);
            String bodyContentNS = details.getBodyContentNS();
            if (!SoapUtils.namespacesMatch(this.payloadNS, bodyContentNS)) {
                String msg;
                String fmt = "Body content namespaces incorrect; expected [%s], got [%s]%n";
                String reason = msg = String.format(fmt, this.payloadNS, bodyContentNS != null ? bodyContentNS : "");
                SoapFaultCodeEnum code = SoapFaultCodeEnum.Sender;
                SoapFaultDetail detail = new SoapFaultDetail(code, reason);
                throw new SoapFaultException(detail, msg);
            }
            HttpSoapResponseImpl response = new HttpSoapResponseImpl(httpResponse);
            processor.prepareSoapResponse(response);
            HttpSoapServletRequestImpl wrappedRequest = new HttpSoapServletRequestImpl(httpRequest, ris);
            HttpServletResponse wrappedResponse = httpResponse;
            this.delegateRequest((HttpServletRequest)wrappedRequest, wrappedResponse);
        }
        catch (SoapFaultException sfex) {
            logger.audit("Problem processing SOAP request: ");
            SoapFaultDetail detail = sfex.getFaultDetail();
            HttpSoapResponseImpl response = new HttpSoapResponseImpl(httpResponse);
            processor.generateFaultResponse(response, detail);
        }
    }

    private void delegateRequest(HttpServletRequest theRequest, HttpServletResponse theResponse) throws SoapFaultException {
        String ERR_FMT;
        DefaultHttpSoapDelegate delegate = null;
        boolean instantiationFailure = false;
        String errorMessage = null;
        Exception errorException = null;
        try {
            Class<?> delegateClassGeneric = Class.forName(this.delegateFQCN);
            Class<DefaultHttpSoapDelegate> delegateClass = delegateClassGeneric.asSubclass(DefaultHttpSoapDelegate.class);
            delegate = delegateClass.newInstance();
            delegate.process(theRequest, theResponse);
        }
        catch (ClassNotFoundException ex) {
            instantiationFailure = true;
            ERR_FMT = "Specified delegate class not found: %s";
            errorMessage = String.format("Specified delegate class not found: %s", this.delegateFQCN);
            errorException = ex;
        }
        catch (ClassCastException ex) {
            instantiationFailure = true;
            ERR_FMT = "Specified delegate class does implement the correct interface: %s";
            errorMessage = String.format("Specified delegate class does implement the correct interface: %s", this.delegateFQCN);
            errorException = ex;
        }
        catch (IllegalAccessException ex) {
            instantiationFailure = true;
            ERR_FMT = "IllegalAccessException when creating SOAP delegate: %s";
            errorMessage = String.format("IllegalAccessException when creating SOAP delegate: %s", this.delegateFQCN);
            errorException = ex;
        }
        catch (InstantiationException ex) {
            instantiationFailure = true;
            ERR_FMT = "InstantiationException when creating SOAP delegate: %s";
            errorMessage = String.format("InstantiationException when creating SOAP delegate: %s", this.delegateFQCN);
            errorException = ex;
        }
        if (instantiationFailure) {
            SoapFaultCodeEnum code = SoapFaultCodeEnum.Receiver;
            String reason = "Problem processing the request";
            SoapFaultDetail detail = new SoapFaultDetail(code, reason);
            throw new SoapFaultException(detail, errorMessage, errorException);
        }
    }
}

