/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import uk.gov.hmrc.aspire.esps.lts.logger.AuditLogger;
import uk.gov.hmrc.aspire.esps.lts.logger.LoggerFactory;
import uk.gov.hmrc.aspire.lts.LTSSystemException;
import uk.gov.hmrc.aspire.lts.connectors.soap.http.xmlprocessor.http.HttpSoapClientServletRequestImpl;
import uk.gov.hmrc.aspire.lts.connectors.soap.http.xmlprocessor.http.ServletInputStreamAdapter;

public class SoapClientServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static AuditLogger logger = LoggerFactory.getAuditLogger();
    private static final String PAYLOAD = "PAYLOAD";
    private static final String FILENAME = "FILENAME";

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        logger.audit("Processing SOAP message received via file upload.");
        Map<String, Object> data = this.getDataFromRequest(request);
        ServletInputStreamAdapter payload = new ServletInputStreamAdapter((InputStream)data.get(PAYLOAD));
        HttpSoapClientServletRequestImpl wrappedRequest = new HttpSoapClientServletRequestImpl(request, payload);
        wrappedRequest.setContentType("application/soap+xml");
        String uri = (String)data.get("hiddenuri");
        this.composeResponsePage(uri, (HttpServletRequest)wrappedRequest, response);
    }

    protected Map<String, Object> getDataFromRequest(HttpServletRequest request) throws IOException {
        HashMap<String, Object> requestData = new HashMap<String, Object>();
        ServletFileUpload multiPartData = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        List dataItems = null;
        try {
            dataItems = multiPartData.parseRequest(request);
        }
        catch (Exception e) {
            throw new LTSSystemException("Error retrieving multipart data from request", e);
        }
        if (dataItems != null && dataItems.size() > 0) {
            int n = dataItems.size();
            for (int i = 0; i < n; ++i) {
                FileItem item = (FileItem)dataItems.get(i);
                if (item.getFieldName().equalsIgnoreCase("submissionFile")) {
                    InputStream is = item.getInputStream();
                    requestData.put(PAYLOAD, is);
                    requestData.put(FILENAME, item.getName());
                }
                if (!item.getFieldName().equalsIgnoreCase("hiddenuri")) continue;
                requestData.put("hiddenuri", item.getString());
            }
        }
        return requestData;
    }

    private void composeResponsePage(String uri, HttpServletRequest request, HttpServletResponse response) {
        try {
            response.setContentType("text/html");
            ServletOutputStream out = response.getOutputStream();
            StringBuilder buff = new StringBuilder();
            buff.append("<html>");
            buff.append("<head><title>Lts Validation Results</title>");
            buff.append("<link rel='stylesheet' href='/LTS/resources/style/hmrc.css' type='text/css'></link>");
            buff.append("<link rel='stylesheet' href='/LTS/resources/style/print.css' type='text/css' media='print'></link>");
            buff.append("<link rel='stylesheet' href='/LTS/resources/style/header.css' type='text/css'></link>");
            buff.append("<link rel='stylesheet' href='/LTS/resources/style/banner.css' type='text/css'></link>");
            buff.append("<link rel='stylesheet' href='/LTS/resources/style/portlet.css' type='text/css'></link>");
            buff.append("<link rel='stylesheet' href='/LTS/resources/style/footer.css' type='text/css'></link>");
            buff.append("<link rel='stylesheet' href='/LTS/resources/style/lists.css' type='text/css'></link>");
            buff.append("<link rel='stylesheet' href='/LTS/resources/style/tables.css' type='text/css'></link>");
            buff.append("<link rel='stylesheet' href='/LTS/resources/style/forms.css' type='text/css'></link>");
            buff.append("<link rel='stylesheet' href='/LTS/resources/style/abt.css' type='text/css'></link>");
            buff.append("</head>");
            buff.append("<body>");
            buff.append("<div id='header'>");
            buff.append("<img src='/LTS/resources/images/hmrcLogo.gif' alt='HM Revenue &amp; Customs' width='160' height='62' align='left' />");
            buff.append("<div id='header-title'>Online services</div>");
            buff.append("<a name='main' class='screen-reader'></a>");
            buff.append("</div>");
            buff.append("<div id='banner'><h1 class='no-menu'>Local Test Service</h1></div>");
            buff.append("<div align='right'><font size='2'><b> <i> LTS 2025 </i> </b></font></div>");
            buff.append("<div class='columns'> <div class='column'><div class='portlet no-title-bar'><div class='portlet-header'><h2>&nbsp;</h2></div> <div class='portlet-body'>");
            buff.append("<form><TABLE><DIV>Validator Response</DIV><TR><TD valign='top'><textarea rows='25' cols='110'>");
            RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(uri);
            SoapMessageValidationServletResponseWrapper responseWrapper = new SoapMessageValidationServletResponseWrapper(response);
            dispatcher.include((ServletRequest)request, (ServletResponse)responseWrapper);
            buff.append(responseWrapper.getContent());
            buff.append("</textarea></TD></TR>");
            buff.append("<TR><TD>  <a href='/LTS/EMCS'>Return to upload page.</a></TD></TR>");
            buff.append("</form></TABLE></div></div></div></div></body></html>");
            byte[] bytes = buff.toString().getBytes("UTF-8");
            out.write(bytes);
        }
        catch (IOException e) {
            System.out.println("Unable to write to output stream");
            e.printStackTrace();
        }
        catch (ServletException e) {
            System.out.println("Unable to dispatch to SOAP servlet");
            e.printStackTrace();
        }
    }

    private final class SoapMessageValidationServletResponseWrapper
    extends HttpServletResponseWrapper {
        final StringWriter sw;

        SoapMessageValidationServletResponseWrapper(HttpServletResponse response) {
            super(response);
            this.sw = new StringWriter();
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return new ServletOutputStream(){

                public void write(int b) throws IOException {
                    SoapMessageValidationServletResponseWrapper.this.sw.write(b);
                }

                public void setWriteListener(WriteListener ignored) {
                    logger.audit("Ignoring attempt to add a write listener to a servlet output stream as it is not supported.");
                }

                public boolean isReady() {
                    return true;
                }
            };
        }

        public PrintWriter getWriter() throws IOException {
            return new PrintWriter(this.sw);
        }

        public String getContent() {
            return this.sw.toString();
        }
    }
}

