/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.soap.http.delegate.emcs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.util.Streams;
import uk.gov.hmrc.aspire.esps.lts.logger.AuditLogger;
import uk.gov.hmrc.aspire.esps.lts.logger.LoggerFactory;
import uk.gov.hmrc.aspire.lts.LTSSystemException;
import uk.gov.hmrc.aspire.lts.composers._IMessageComposer;
import uk.gov.hmrc.aspire.lts.composers.envelope.SOAPEnvWrapper;
import uk.gov.hmrc.aspire.lts.model.LTSRequest;
import uk.gov.hmrc.aspire.lts.model.LTSResponse;
import uk.gov.hmrc.aspire.lts.requesthandlers.HandlerChain;
import uk.gov.hmrc.aspire.lts.soap.http.delegate.HttpSoapDelegate;
import uk.gov.hmrc.aspire.lts.spox.SOAPMessageListener;
import uk.gov.hmrc.aspire.lts.utils.ConfigReader;
import uk.gov.hmrc.aspire.lts.utils.Constants;
import uk.gov.hmrc.aspire.lts.utils.StreamUtils;
import uk.gov.hmrc.chris.spox.Listener;
import uk.gov.hmrc.chris.spox.XMLHandler;
import uk.gov.hmrc.chris.utils.streaming.StreamingException;
import uk.gov.hmrc.chris.utils.streaming.StringUtils;

public abstract class DefaultHttpSoapDelegate
implements HttpSoapDelegate {
    protected static final String PS = Constants.PATH_SEPARATOR;
    protected static final String LTS_ROOT = Constants.LTS_ROOT;
    private static final int BUFFER_SIZE = 10240;
    private static final String WS_CONFIG_DIR = LTS_ROOT + PS + "resources" + PS + "config" + PS + "NonConfigurable";
    private static AuditLogger logger = LoggerFactory.getAuditLogger();

    protected abstract String getConfigFileName();

    protected abstract String getStaticResponseFilepath();

    protected abstract String getAuthStaticResponseFilepath();

    protected abstract _IMessageComposer getMessageComposer();

    public OMElement generateInvalidResponse() {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace errorRespNamespace = factory.createOMNamespace("http://www.govtalk.gov.uk/CM/errorresponse", "");
        OMElement errorResponse = factory.createOMElement("ErrorResponse", errorRespNamespace);
        OMElement application = factory.createOMElement("Application", errorRespNamespace, (OMContainer)errorResponse);
        OMElement messageCount = factory.createOMElement("MessageCount", errorRespNamespace, (OMContainer)application);
        messageCount.addChild((OMNode)factory.createOMText("1"));
        OMElement error = factory.createOMElement("Error", errorRespNamespace, (OMContainer)errorResponse);
        OMElement raisedBy = factory.createOMElement("RaisedBy", errorRespNamespace, (OMContainer)error);
        raisedBy.addChild((OMNode)factory.createOMText("ChRIS"));
        OMElement numberNode = factory.createOMElement("Number", errorRespNamespace, (OMContainer)error);
        numberNode.addChild((OMNode)factory.createOMText("8998"));
        OMElement typeNode = factory.createOMElement("Type", errorRespNamespace, (OMContainer)error);
        typeNode.addChild((OMNode)factory.createOMText("business"));
        OMElement textNode = factory.createOMElement("Text", errorRespNamespace, (OMContainer)error);
        textNode.addChild((OMNode)factory.createOMText("Please check that the correct 'Message Type' has been specified in your xml file and that your submission contains no invalid characters."));
        OMElement locationNode = factory.createOMElement("Location", errorRespNamespace, (OMContainer)error);
        locationNode.addChild((OMNode)factory.createOMText("/Envelope/Header/Info/ServiceMessageType"));
        return errorResponse;
    }

    @Override
    public void process(HttpServletRequest request, HttpServletResponse response) {
        logger.audit("Starting processing of SOAP message");
        ConfigReader reader = new ConfigReader(WS_CONFIG_DIR + PS + this.getConfigFileName());
        Properties config = null;
        try {
            config = reader.getConfig();
        }
        catch (Exception exc) {
            throw new LTSSystemException("Error reading config file - " + WS_CONFIG_DIR + PS + this.getConfigFileName(), exc);
        }
        LTSRequest ltsRequest = new LTSRequest();
        LTSResponse ltsResponse = new LTSResponse();
        DiskFileItemFactory fileItemFactory = new DiskFileItemFactory();
        fileItemFactory.setSizeThreshold(0x100000);
        FileItem payloadFileItem = fileItemFactory.createItem("payload", "application/xml", false, null);
        try {
            Streams.copy((InputStream)request.getInputStream(), (OutputStream)payloadFileItem.getOutputStream(), (boolean)true);
        }
        catch (IOException ioe) {
            throw new LTSSystemException("Unable to create an OutputStream to the payload data.", ioe);
        }
        SOAPMessageListener soapListener = new SOAPMessageListener();
        try {
            XMLHandler handler = new XMLHandler(new Listener[]{soapListener});
            handler.readXML(payloadFileItem.getInputStream());
        }
        catch (IOException ioe) {
            throw new LTSSystemException("Unable to create an InputStream from the payload data.", ioe);
        }
        String messageClass = soapListener.getMessageClass();
        String messageNamespace = soapListener.getMessageNamespace();
        String configMessageClass = config.getProperty("ServiceMessageType");
        String configMessageNamespace = config.getProperty("MessageNamespace");
        OMElement responseMsg = null;
        if (!configMessageClass.equals(messageClass) || !configMessageNamespace.equals(messageNamespace)) {
            responseMsg = this.generateInvalidResponse();
        } else {
            ltsResponse.setEnvelopeWrapper(new SOAPEnvWrapper());
            ltsRequest.setOriginalPayload(payloadFileItem);
            ltsRequest.setMessageType(messageClass);
            ltsRequest.setConfig(config);
            ltsRequest.setAttribute("Static", this.getStaticResponseFilepath());
            ltsRequest.setAttribute("Authentication", this.getAuthStaticResponseFilepath());
            ltsRequest.setValidationNamespace(messageNamespace);
            ltsRequest.setAttribute("Filename", WS_CONFIG_DIR);
            String[][] classNames = (String[][])config.get("Handlers");
            HandlerChain chain = HandlerChain.getChain(classNames);
            try {
                chain.process(ltsRequest, ltsResponse);
            }
            catch (Exception e) {
                throw new LTSSystemException("Error initiating/processing the incoming message.", e);
            }
            _IMessageComposer composer = this.getMessageComposer();
            responseMsg = composer.composeMessage(ltsRequest, ltsResponse);
        }
        InputStream responseStream = null;
        try {
            responseStream = StringUtils.convertStringToInputStream((String)responseMsg.toString());
        }
        catch (StreamingException se) {
            throw new LTSSystemException(se);
        }
        try {
            StreamUtils.copyInputStreamToOutputStream(responseStream, (OutputStream)response.getOutputStream(), 10240);
        }
        catch (IOException ioe) {
            throw new LTSSystemException(ioe);
        }
    }
}

