/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.spox;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import uk.gov.hmrc.aspire.esps.lts.logger.LoggerFactory;
import uk.gov.hmrc.aspire.lts.LTSSystemException;
import uk.gov.hmrc.aspire.lts.spox.DefaultListener;
import uk.gov.hmrc.aspire.lts.spox.MultipleCompressedElementsException;
import uk.gov.hmrc.chris.spox.SPOXException;
import uk.gov.hmrc.chris.spox.xml.Attribute;
import uk.gov.hmrc.chris.utils.decompression.GZipOutputStream;
import uk.gov.hmrc.chris.utils.decompression.InflaterOutputStream;
import uk.gov.hmrc.chris.utils.decompression.ZipOutputStream;
import uk.gov.hmrc.chris.utils.encoding.base64.Base64;
import uk.gov.hmrc.chris.utils.xml.XMLBuilder;

public class DecompressionDataListener
extends DefaultListener {
    public static final String GZIP = "gzip";
    public static final String ZIP = "zip";
    public static final String DEFAULT_COMPRESSION_TYPE = "gzip";
    protected XMLBuilder builder;
    protected boolean insideXPath;
    protected String compressedElementXpath;
    private byte compressedElementCount = 0;
    protected String compressionTypeAttributeName;
    protected String compressionType;
    protected OutputStream decompressingOut;
    private InflaterOutputStream inflaterOutputStream;
    protected OutputStream plainOut;

    public DecompressionDataListener(OutputStream plainOutputStream, String compressedElementXPath, String compressionTypeAttributeName) {
        if (plainOutputStream == null) {
            throw new NullPointerException("plainOutputStream");
        }
        if (compressedElementXPath == null) {
            throw new NullPointerException("compressedElementXPath");
        }
        if (compressionTypeAttributeName == null) {
            throw new NullPointerException("compressionTypeAttributeName");
        }
        try {
            this.plainOut = plainOutputStream;
            this.compressedElementXpath = compressedElementXPath;
            this.compressionTypeAttributeName = compressionTypeAttributeName;
            this.builder = new XMLBuilder(Boolean.valueOf(true), this.plainOut);
        }
        catch (XMLBuilder.XMLBuilderException e) {
            throw new SPOXException("Could not intialise a XMLBuilder used for decompression", (Throwable)e);
        }
    }

    @Override
    public void characterDataFound(char[] data, int size) throws SPOXException {
        if (!this.insideXPath) {
            try {
                this.builder.writeText(new String(data, 0, size));
            }
            catch (XMLBuilder.XMLBuilderException e) {
                throw new SPOXException("Could not capture text data", (Throwable)e);
            }
        }
        try {
            if (this.decompressingOut == null) {
                this.builder.writeText("");
                this.builder.flush();
            }
            this.processCompressedData(data, size);
        }
        catch (Exception e) {
            throw new SPOXException("Could not process compressed data", (Throwable)e);
        }
    }

    @Override
    public void documentFinished() throws SPOXException {
        try {
            this.builder.endDocument();
            this.builder = null;
            if (this.decompressingOut != null) {
                this.decompressingOut.flush();
                this.decompressingOut.close();
                this.decompressingOut = null;
            }
        }
        catch (XMLBuilder.XMLBuilderException e) {
            throw new SPOXException("Could not end the XML document", (Throwable)e);
        }
        catch (IOException ie) {
            throw new SPOXException("Could not close the streams", (Throwable)ie);
        }
    }

    @Override
    public void endElementFound(String name) throws SPOXException {
        try {
            if (!this.insideXPath) {
                this.builder.writeEndElement();
            } else {
                this.decompressingOut.flush();
            }
        }
        catch (Exception e) {
            throw new SPOXException("Could not end the element within the form", (Throwable)e);
        }
    }

    @Override
    public String[] getXPaths() throws SPOXException {
        return new String[]{this.compressedElementXpath};
    }

    @Override
    public void startElementFound(String name, Attribute ... attributes) throws SPOXException {
        if (!this.insideXPath) {
            try {
                this.builder.writeStartElement(name);
                for (int x = 0; x < attributes.length; ++x) {
                    this.builder.writeAttribute(attributes[x].getName(), attributes[x].getValue());
                }
            }
            catch (XMLBuilder.XMLBuilderException e) {
                throw new SPOXException("Could not end the element with XMLBuilder", (Throwable)e);
            }
        } else if (attributes != null && this.compressionTypeAttributeName != null) {
            for (Attribute currAttribute : attributes) {
                if (!this.compressionTypeAttributeName.equals(currAttribute.getName())) continue;
                this.compressionType = currAttribute.getValue();
            }
        }
    }

    @Override
    public void xpathFinished() throws SPOXException {
        this.insideXPath = false;
        if (this.decompressingOut != null) {
            try {
                this.decompressingOut.flush();
            }
            catch (IOException ioe) {
                throw new SPOXException("Could not write the decompressed data ", (Throwable)ioe);
            }
        }
    }

    @Override
    public void xpathFound(String xpath) throws SPOXException {
        if (xpath.equals(this.compressedElementXpath)) {
            try {
                this.builder.flush();
            }
            catch (XMLBuilder.XMLBuilderException e) {
                throw new SPOXException("Could not write the data before decompression ", (Throwable)e);
            }
            this.insideXPath = true;
            this.compressedElementCount = (byte)(this.compressedElementCount + 1);
            if (this.compressedElementCount > 1) {
                throw new MultipleCompressedElementsException(null, xpath);
            }
        }
    }

    public boolean getCompressedSubmissionFlag() {
        return this.compressedElementCount > 0;
    }

    protected void processCompressedData(char[] data, int size) {
        if (data != null) {
            try {
                if (this.decompressingOut == null) {
                    if (this.compressionType == null) {
                        LoggerFactory.getAuditLogger().writeLog("Using default decompression type (gzip), because no compression type attribute has been specified in the configuration.");
                        this.compressionType = "gzip";
                    }
                    if (ZIP.equalsIgnoreCase(this.compressionType)) {
                        this.inflaterOutputStream = new ZipOutputStream(this.plainOut);
                    } else if ("gzip".equalsIgnoreCase(this.compressionType)) {
                        this.inflaterOutputStream = new GZipOutputStream(this.plainOut);
                    } else {
                        LoggerFactory.getAuditLogger().writeLog("The Compression type is not recognised : " + this.compressionType);
                        throw new LTSSystemException("Failure to process the compressed file.");
                    }
                    this.decompressingOut = new BufferedOutputStream((OutputStream)this.inflaterOutputStream, 1024);
                    this.decompressingOut = new Base64.OutputStream(this.decompressingOut, 0);
                }
                this.decompressingOut.write(new String(data).getBytes(), 0, size);
            }
            catch (IOException ie) {
                throw new SPOXException("IO Exception occured while writing decompressed data ", (Throwable)ie);
            }
        }
    }
}

