/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.spox;

import java.util.HashMap;
import java.util.StringTokenizer;
import uk.gov.hmrc.aspire.lts.spox.DefaultListener;
import uk.gov.hmrc.chris.spox.SPOXException;
import uk.gov.hmrc.chris.spox.xml.Attribute;

public class SOAPMessageListener
extends DefaultListener {
    private String messageClass;
    private String messageNamespace;
    private String elementPassed = "";
    private HashMap<String, String> namespaceMap = new HashMap();
    private static final String SERVICEMESSAGETYPE_NODE = "ServiceMessageType";
    private static final String SOAPBODY_NODE = "Body";
    private static final String SOAPENVELOPE_NODE = "Envelope";
    private static final String SOAPHEADER_NODE = "Header";
    private StringBuffer data;

    @Override
    public void startElementFound(String name, Attribute ... attributes) throws SPOXException {
        this.data = new StringBuffer();
        String elementPrefix = null;
        String elementName = null;
        StringTokenizer t = new StringTokenizer(name, ":");
        if (t.countTokens() == 2) {
            elementPrefix = t.nextToken();
            elementName = t.nextToken();
        } else {
            elementName = name;
        }
        for (Attribute attribute : attributes) {
            if (attribute.getName().indexOf("xmlns:") == -1) continue;
            int colonPosition = elementName.indexOf(58);
            colonPosition = attribute.getName().indexOf(58);
            String prefix = attribute.getName().substring(colonPosition + 1, attribute.getName().length());
            this.namespaceMap.put(prefix, attribute.getValue());
        }
        if (elementName.equals(SOAPENVELOPE_NODE)) {
            this.elementPassed = SOAPENVELOPE_NODE;
        }
        if (elementName.equals(SOAPHEADER_NODE) && this.elementPassed.equals(SOAPENVELOPE_NODE)) {
            this.elementPassed = SOAPHEADER_NODE;
        }
        if (elementName.equals(SOAPBODY_NODE) && this.elementPassed.equals(SOAPHEADER_NODE)) {
            this.elementPassed = SOAPBODY_NODE;
        } else if (this.elementPassed.equals(SOAPBODY_NODE)) {
            if (elementPrefix != null) {
                this.messageNamespace = this.namespaceMap.get(elementPrefix);
            } else {
                for (Attribute attribute : attributes) {
                    if (attribute.getName() != "xmlns") continue;
                    this.messageNamespace = attribute.getValue();
                }
            }
            this.elementPassed = "";
        }
    }

    @Override
    public void endElementFound(String name) throws SPOXException {
        String elementName = name;
        if (elementName.indexOf(58) != -1) {
            elementName = elementName.substring(elementName.indexOf(58) + 1, elementName.length());
        }
        if (elementName.equals(SERVICEMESSAGETYPE_NODE)) {
            this.messageClass = this.data.toString();
        }
    }

    @Override
    public String[] getXPaths() throws SPOXException {
        return new String[]{"Errors/Error"};
    }

    @Override
    public void characterDataFound(char[] data, int arg1) throws SPOXException {
        this.data.append(data);
    }

    public String getMessageNamespace() {
        return this.messageNamespace;
    }

    public String getMessageClass() {
        return this.messageClass;
    }
}

