/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.spox;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import uk.gov.hmrc.aspire.lts.spox.DefaultListener;
import uk.gov.hmrc.chris.spox.SPOXException;
import uk.gov.hmrc.chris.spox.xml.Attribute;

public class SpoxConfigListener
extends DefaultListener {
    private Map<String, String> xPaths = null;
    private Map<String, String> multiXPaths = null;
    private Map<String, String> swappedXPaths = new HashMap<String, String>();
    private static Map<String, Map<String, String>> cachedXPathMaps = Collections.synchronizedMap(new HashMap());
    private static Map<String, Map<String, String>> cachedMultiXPathMaps = Collections.synchronizedMap(new HashMap());
    private boolean isInsideXPath = false;
    private boolean isInsideMultiXPath = false;
    private boolean MultiXPathChild = false;
    private String key = "";
    private Map<String, String> results = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpoxConfigListener(String msgType, Map<String, String> xpaths, String valNSElement) {
        Map<String, Map<String, String>> map = cachedXPathMaps;
        synchronized (map) {
            this.xPaths = cachedXPathMaps.get(msgType);
            if (this.xPaths == null) {
                this.xPaths = xpaths;
                cachedXPathMaps.put(msgType, this.xPaths);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpoxConfigListener(String msgType, Map<String, String> xpaths, Map<String, String> multiXpaths, String valNSElement) {
        Map<String, Map<String, String>> map = cachedXPathMaps;
        synchronized (map) {
            this.xPaths = cachedXPathMaps.get(msgType);
            if (this.xPaths == null) {
                this.xPaths = xpaths;
                cachedXPathMaps.put(msgType, this.xPaths);
            }
        }
        map = cachedMultiXPathMaps;
        synchronized (map) {
            this.multiXPaths = cachedMultiXPathMaps.get(msgType);
            if (this.multiXPaths == null) {
                this.multiXPaths = multiXpaths;
                cachedMultiXPathMaps.put(msgType, this.multiXPaths);
                return;
            }
        }
    }

    public static SpoxConfigListener getInstance(String msgType, Map<String, String> xpaths, String valNSElement) {
        return new SpoxConfigListener(msgType, xpaths, valNSElement);
    }

    public static SpoxConfigListener getInstance(String msgType, Map<String, String> xpaths, Map<String, String> multiXpaths, String valNSElement) {
        return new SpoxConfigListener(msgType, xpaths, multiXpaths, valNSElement);
    }

    @Override
    public void xpathFound(String xpath) {
        if (this.xPaths.containsValue(xpath)) {
            this.key = this.getSwappedXPaths().get(xpath);
            this.isInsideXPath = true;
        }
        if (this.multiXPaths != null && this.multiXPaths.containsValue(xpath)) {
            this.isInsideMultiXPath = true;
        }
    }

    @Override
    public void startElementFound(String name, Attribute ... attributes) throws SPOXException {
        if (this.isInsideMultiXPath) {
            if (this.MultiXPathChild) {
                this.key = attributes[0].getValue();
            } else {
                this.MultiXPathChild = true;
            }
        }
    }

    @Override
    public void endElementFound(String name) throws SPOXException {
        this.key = "";
    }

    @Override
    public void xpathFinished() {
        this.key = "";
        this.isInsideXPath = false;
        this.isInsideMultiXPath = false;
        this.MultiXPathChild = false;
    }

    @Override
    public void nameSpaceFinished() {
    }

    @Override
    public void nameSpaceFound() {
    }

    @Override
    public String[] getXPaths() {
        if (this.multiXPaths != null) {
            ArrayList<String> xpaths = new ArrayList<String>();
            xpaths.addAll(this.xPaths.values());
            xpaths.addAll(this.multiXPaths.values());
            return xpaths.toArray(new String[xpaths.size()]);
        }
        return this.xPaths.values().toArray(new String[this.xPaths.size()]);
    }

    @Override
    public void characterDataFound(char[] data, int Size) {
        if (this.isInsideXPath || this.isInsideMultiXPath && this.MultiXPathChild) {
            if (!this.results.containsKey(this.key)) {
                this.results.put(this.key, new String(data));
            } else {
                String combinedData = this.results.get(this.key) + new String(data);
                this.results.put(this.key, combinedData);
            }
        }
    }

    @Override
    public String getNameSpace() throws SPOXException {
        return null;
    }

    public Map<String, String> getResults() {
        return this.results;
    }

    private Map<String, String> getSwappedXPaths() {
        if (!this.swappedXPaths.isEmpty()) {
            return this.swappedXPaths;
        }
        for (String s : this.xPaths.keySet()) {
            this.swappedXPaths.put(this.xPaths.get(s), s);
        }
        return this.swappedXPaths;
    }
}

