/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.spox;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.StringTokenizer;
import uk.gov.hmrc.aspire.lts.spox.DefaultListener;
import uk.gov.hmrc.chris.spox.Listener;
import uk.gov.hmrc.chris.spox.SPOXException;
import uk.gov.hmrc.chris.spox.XMLHandler;
import uk.gov.hmrc.chris.spox.xml.Attribute;

public class VATListener
extends DefaultListener {
    private String periodID = "";
    private String periodStart = "";
    private String periodEnd = "";
    private String defaultCurrency = "";
    private String netVAT = "";
    private String netECSupplies = "";
    private String totalVAT = "";
    private String vatReclaimedOnInputs = "";
    private String aasBalancingPayment = "";
    private String messageNamespace = null;
    private String messagePrefix = "";
    private String traderVRN = "";
    private String schemaLocation = "";
    private String gatewayTimestamp = "";
    private String schemaVersion = "";
    private HashMap<String, String> namespaceMap = new HashMap();
    private static final String IRENVELOPE_NODE = "IRenvelope";
    private static final String VAT_PERIOD_ID = "PeriodID";
    private static final String VAT_PERIOD_START = "PeriodStart";
    private static final String VAT_PERIOD_END = "PeriodEnd";
    private static final String VAT_CURRENCY_CODE = "DefaultCurrency";
    private static final String VAT_NETVAT = "NetVAT";
    private static final String VAT_NETECSUPPLIES = "NetECSupplies";
    private static final String VAT_TOTALVAT = "TotalVAT";
    private static final String VAT_VATRECLAIMED = "VATReclaimedOnInputs";
    private static final String VAT_AASBALANCE = "AASBalancingPayment";
    private static final String VAT_VRN = "VATRegNo";
    private static final String SCHEMA_LOCATION = "schemaLocation";
    private static final String GATEWAY_TIMESTAMP = "GatewayTimestamp";
    private static final String SCHEMA_VERSION = "SchemaVersion";
    private StringBuffer data;

    @Override
    public void startElementFound(String name, Attribute ... attributes) throws SPOXException {
        this.data = new StringBuffer();
        String elementPrefix = null;
        String elementName = null;
        StringTokenizer t = new StringTokenizer(name, ":");
        if (t.countTokens() == 2) {
            elementPrefix = t.nextToken();
            elementName = t.nextToken();
        } else {
            elementName = name;
        }
        for (Attribute attribute : attributes) {
            String prefix;
            int colonPosition;
            if (attribute.getName().indexOf("xmlns:") != -1) {
                colonPosition = elementName.indexOf(58);
                colonPosition = attribute.getName().indexOf(58);
                prefix = attribute.getName().substring(colonPosition + 1, attribute.getName().length());
                this.namespaceMap.put(prefix, attribute.getValue());
                continue;
            }
            if (attribute.getName().indexOf("xsi:") == -1) continue;
            colonPosition = elementName.indexOf(58);
            colonPosition = attribute.getName().indexOf(58);
            prefix = attribute.getName().substring(colonPosition + 1, attribute.getName().length());
            if (!prefix.contentEquals(SCHEMA_LOCATION)) continue;
            this.schemaLocation = attribute.getValue();
        }
        if (elementName.equals(IRENVELOPE_NODE)) {
            if (elementPrefix != null) {
                this.messageNamespace = this.namespaceMap.get(elementPrefix);
                this.messagePrefix = elementPrefix;
            } else {
                for (Attribute attribute : attributes) {
                    if (attribute.getName() != "xmlns") continue;
                    this.messageNamespace = attribute.getValue();
                    this.messagePrefix = "";
                }
            }
        }
        if (this.messageNamespace != null && elementName.contentEquals("Key")) {
            for (Attribute attribute : attributes) {
                if (!attribute.getName().equals("Type") || !attribute.getValue().equals(VAT_VRN)) continue;
                this.traderVRN = "VRN";
            }
        }
    }

    @Override
    public void endElementFound(String name) throws SPOXException {
        String elementName = name;
        if (elementName.indexOf(58) != -1) {
            elementName = elementName.substring(elementName.indexOf(58) + 1, elementName.length());
        }
        if (elementName.equals(GATEWAY_TIMESTAMP)) {
            this.gatewayTimestamp = this.data.toString();
        }
        if (this.messageNamespace != null) {
            if (elementName.equals(SCHEMA_VERSION)) {
                this.schemaVersion = "1.0";
            } else if (elementName.equals(VAT_PERIOD_ID)) {
                this.periodID = this.data.toString();
            } else if (elementName.equals(VAT_PERIOD_START)) {
                this.periodStart = this.data.toString();
            } else if (elementName.equals(VAT_PERIOD_END)) {
                this.periodEnd = this.data.toString();
            } else if (elementName.equals(VAT_CURRENCY_CODE)) {
                this.defaultCurrency = this.data.toString();
            } else if (elementName.equals(VAT_NETVAT)) {
                this.netVAT = this.data.toString();
            } else if (elementName.equals(VAT_NETECSUPPLIES)) {
                this.netECSupplies = this.data.toString();
            } else if (elementName.equals(VAT_TOTALVAT)) {
                this.totalVAT = this.data.toString();
            } else if (elementName.equals(VAT_VATRECLAIMED)) {
                this.vatReclaimedOnInputs = this.data.toString();
            } else if (elementName.equals(VAT_AASBALANCE)) {
                this.aasBalancingPayment = this.data.toString();
            } else if (this.traderVRN.equals("VRN")) {
                this.traderVRN = this.data.toString();
            }
        }
    }

    @Override
    public String[] getXPaths() throws SPOXException {
        return new String[]{"Errors/Error"};
    }

    @Override
    public void characterDataFound(char[] data, int arg1) throws SPOXException {
        this.data.append(data);
    }

    public String getMessageNamespace() {
        return this.messageNamespace;
    }

    public String getperiodID() {
        return this.periodID;
    }

    public String getPeriodStart() {
        return this.periodStart;
    }

    public String getPeriodEnd() {
        return this.periodEnd;
    }

    public String getDefaultCurrency() {
        return this.defaultCurrency;
    }

    public String getNetVAT() {
        return this.netVAT;
    }

    public String getNetECSupplies() {
        return this.netECSupplies;
    }

    public String getTotalVAT() {
        return this.totalVAT;
    }

    public String getVatReclaimedOnInputs() {
        return this.vatReclaimedOnInputs;
    }

    public String getAasBalancingPayment() {
        return this.aasBalancingPayment;
    }

    public String getTraderVRN() {
        return this.traderVRN;
    }

    public String getGatewayTimestamp() {
        return this.gatewayTimestamp;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public HashMap<String, String> getNameSpaceMap() {
        return this.namespaceMap;
    }

    public String getMessagePrefix() {
        return this.messagePrefix;
    }

    public static void main(String[] args) {
        try {
            VATListener vatListener = new VATListener();
            XMLHandler handler = new XMLHandler(new Listener[]{vatListener});
            handler.readXML((InputStream)new FileInputStream(new File("c:\\siddo\\vat\\HMRC-VAT-v0-91-20090219\\VATDeclarationRequest-testCases\\AASBALANCINGPAYMENT.0.02.xml")));
            boolean sid = false;
            boolean bl = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

