/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.spox;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import uk.gov.hmrc.aspire.lts.model.LTSResponse;
import uk.gov.hmrc.aspire.lts.spox.DefaultListener;
import uk.gov.hmrc.chris.spox.SPOXException;
import uk.gov.hmrc.chris.spox.xml.Attribute;

public class ValidationErrorsListener
extends DefaultListener {
    private int number;
    private String type;
    private String text;
    private String location;
    private String developerMessage;
    private static final String ERROR_NODE = "Error";
    private static final String NUMBER_NODE = "Number";
    private static final String TYPE_NODE = "Type";
    private static final String TEXT_NODE = "Text";
    private static final String LOCATION_NODE = "Location";
    private static final String DEVELOPER_MESSAGE_NODE = "DeveloperMessage";
    private StringBuffer data;
    private OMFactory factory = OMAbstractFactory.getOMFactory();
    private OMNamespace errorRespNamespace = this.factory.createOMNamespace("http://www.govtalk.gov.uk/CM/errorresponse", "");
    private LTSResponse response;
    private int errorCount;

    public ValidationErrorsListener(LTSResponse response) {
        this.response = response;
        this.errorCount = 0;
    }

    @Override
    public void endElementFound(String name) throws SPOXException {
        String elementName = name;
        if (elementName.indexOf(58) != -1) {
            elementName = elementName.substring(elementName.indexOf(58) + 1, elementName.length());
        }
        if (elementName.equals(NUMBER_NODE)) {
            try {
                this.number = Integer.parseInt(this.data.toString());
            }
            catch (NumberFormatException e) {
                this.number = 0;
            }
        } else if (elementName.equals(TYPE_NODE)) {
            this.type = this.data.toString();
        } else if (elementName.equals(TEXT_NODE)) {
            this.text = this.data.toString();
        } else if (elementName.equals(LOCATION_NODE)) {
            this.location = this.data.toString();
        } else if (elementName.equals(DEVELOPER_MESSAGE_NODE)) {
            this.developerMessage = this.data.toString();
        } else if (elementName.equals(ERROR_NODE)) {
            this.response.addError("validation" + this.errorCount, this.buildError());
            ++this.errorCount;
            this.number = 0;
            this.type = null;
            this.text = null;
            this.location = null;
            this.developerMessage = null;
        }
    }

    private OMNode buildError() {
        OMElement error = this.factory.createOMElement(ERROR_NODE, this.errorRespNamespace);
        OMElement raisedBy = this.factory.createOMElement("RaisedBy", this.errorRespNamespace, (OMContainer)error);
        raisedBy.addChild((OMNode)this.factory.createOMText("ChRIS"));
        OMElement numberNode = this.factory.createOMElement(NUMBER_NODE, this.errorRespNamespace, (OMContainer)error);
        numberNode.addChild((OMNode)this.factory.createOMText(Integer.toString(this.number)));
        OMElement typeNode = this.factory.createOMElement(TYPE_NODE, this.errorRespNamespace, (OMContainer)error);
        typeNode.addChild((OMNode)this.factory.createOMText(this.type));
        OMElement textNode = this.factory.createOMElement(TEXT_NODE, this.errorRespNamespace, (OMContainer)error);
        textNode.addChild((OMNode)this.factory.createOMText(this.text));
        OMElement locationNode = this.factory.createOMElement(LOCATION_NODE, this.errorRespNamespace, (OMContainer)error);
        locationNode.addChild((OMNode)this.factory.createOMText(this.location));
        if (this.developerMessage != null) {
            OMElement applicationNode = this.factory.createOMElement("Application", this.errorRespNamespace, (OMContainer)error);
            OMElement messagesNode = this.factory.createOMElement("Messages", this.errorRespNamespace, (OMContainer)applicationNode);
            OMElement developerMessageNode = this.factory.createOMElement(DEVELOPER_MESSAGE_NODE, this.errorRespNamespace, (OMContainer)messagesNode);
            developerMessageNode.addChild((OMNode)this.factory.createOMText(this.developerMessage));
        }
        return error;
    }

    @Override
    public String[] getXPaths() throws SPOXException {
        return new String[]{"Errors/Error"};
    }

    @Override
    public void startElementFound(String arg0, Attribute ... arg1) throws SPOXException {
        this.data = new StringBuffer();
    }

    @Override
    public void characterDataFound(char[] data, int arg1) throws SPOXException {
        this.data.append(data);
    }
}

