/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.test;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;
import uk.gov.hmrc.aspire.esps.lts.logger.AuditLogger;
import uk.gov.hmrc.aspire.esps.lts.logger.LoggerFactory;
import uk.gov.hmrc.aspire.esps.validator.Validator;
import uk.gov.hmrc.aspire.lts.servlets.LTSPAYEEoYServlet;
import uk.gov.hmrc.aspire.lts.servlets.LTSPostServlet;
import uk.gov.hmrc.aspire.lts.servlets.LTSServlet;

public class LTSStandalone {
    private static final String WEB_APP_ROOT = "Webapp/";
    private static final String CONTEXT_PATH = "/LTS";
    public static final String LTS_CONFIG_PROPERTY_NAME = "lts.config";
    public static final String VALIDATOR_CONFIG_PROPERTY_NAME = "validator.config";
    public static final String LTS_ROOT_PROPERTY_NAME = "lts.root";
    public static final String LTS_ROOT_VARIABLE_NAME = "LTS_HOME";
    private static final String VERSION_FILE = "VERSION.txt";
    private final File ltsJettyConfigFile;
    private Server jettyServer;

    private LTSStandalone(AuditLogger log) throws Exception {
        String ltsConfigFile = System.getProperty(LTS_CONFIG_PROPERTY_NAME);
        String validatorConfigFilename = System.getProperty(VALIDATOR_CONFIG_PROPERTY_NAME);
        String ltsRoot = System.getProperty(LTS_ROOT_PROPERTY_NAME);
        System.out.println("Audit Logging to: " + log.getLogFilename());
        log.audit("LTS Started");
        if (ltsConfigFile == null || ltsConfigFile.trim().length() == 0) {
            throw new Exception("Missing or empty System property: lts.config");
        }
        if (validatorConfigFilename == null || validatorConfigFilename.trim().length() == 0) {
            throw new Exception("Missing or empty System property: validator.config");
        }
        if (ltsRoot == null || ltsRoot.trim().length() == 0) {
            throw new Exception("You MUST set the LTS_HOME variable - please consult the Installation guide");
        }
        this.ltsJettyConfigFile = new File(ltsConfigFile);
        if (!(this.ltsJettyConfigFile.exists() && this.ltsJettyConfigFile.isFile() && this.ltsJettyConfigFile.canRead() && this.ltsJettyConfigFile.length() != 0L)) {
            throw new Exception("Missing, empty or inaccessible configuration file: " + ltsConfigFile);
        }
        File validatorConfigFile = new File(validatorConfigFilename);
        if (!(validatorConfigFile.exists() && validatorConfigFile.isFile() && validatorConfigFile.canRead() && validatorConfigFile.length() != 0L)) {
            throw new Exception("Missing, empty or inaccessible configuration file: " + validatorConfigFilename);
        }
        File ltsRootDir = new File(ltsRoot);
        if (!(ltsRootDir.exists() && ltsRootDir.isDirectory() && ltsRootDir.canRead())) {
            throw new Exception("Missing, invalid or inaccessible directory (environment variable 'LTS_HOME'): " + ltsRootDir.getAbsolutePath());
        }
        File hmrcToolsRootDir = ltsRootDir.getAbsoluteFile().getParentFile();
        System.setProperty("hmrctools.root", hmrcToolsRootDir.getAbsolutePath());
        Validator.initialise((File)validatorConfigFile);
    }

    private void configureServer() throws Exception {
        System.out.println("Configuring LTS server; Configuration file: " + this.ltsJettyConfigFile.getAbsolutePath());
        new XmlConfiguration(this.ltsJettyConfigFile.toURL()).configure((Object)this.jettyServer);
        WebAppContext webAppContext = new WebAppContext((HandlerContainer)this.jettyServer, WEB_APP_ROOT, CONTEXT_PATH);
        webAppContext.addServlet(LTSServlet.class, "/LTSServlet");
        webAppContext.addServlet(LTSPostServlet.class, "/LTSPostServlet");
        webAppContext.addServlet(LTSPAYEEoYServlet.class, "/LTSPAYEEoYServlet");
        this.jettyServer.setHandler((Handler)webAppContext);
        Configuration.ClassList classlist = Configuration.ClassList.setServerDefault((Server)this.jettyServer);
        classlist.addBefore("org.eclipse.jetty.webapp.JettyWebXmlConfiguration", new String[]{"org.eclipse.jetty.annotations.AnnotationConfiguration"});
        webAppContext.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", (Object)".*/target/classes/|.*\\.jar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        LTSStandalone app = null;
        AuditLogger log = LoggerFactory.getAuditLogger();
        try {
            app = new LTSStandalone(log);
            app.start();
            app.waitForServerToExit();
        }
        catch (Exception e) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bout));
            log.audit(bout.toString());
            System.err.println(e.getMessage());
        }
        finally {
            if (app != null) {
                app.stop();
            }
        }
    }

    private void start() throws Exception {
        this.jettyServer = new Server();
        this.configureServer();
        System.out.println("Starting LTS server...");
        this.jettyServer.start();
        this.printLTSVersionDetails();
        System.out.println("LTS server running.");
    }

    private void printLTSVersionDetails() {
        try {
            File versionFile = new File(new File(System.getProperty("user.dir")).getParent(), VERSION_FILE);
            BufferedReader fileIn = new BufferedReader(new FileReader(versionFile));
            String version = fileIn.readLine();
            if (version != null && version.length() > 0) {
                System.out.println("LTS version: " + version.substring(1));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void stop() throws Exception {
        if (this.jettyServer != null) {
            System.out.println("stopping LTS Server...");
            this.jettyServer.stop();
            System.out.println("LTS Server stopped.");
        }
    }

    private void waitForServerToExit() throws InterruptedException {
        this.jettyServer.join();
    }
}

