/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.utils;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigContentHandler
extends DefaultHandler {
    String current = "";
    private StringBuffer data;
    Attributes attributes = null;
    Properties config = new Properties();
    Map<String, String> decompressionMap = new HashMap<String, String>();
    List<String> handlerList = new LinkedList<String>();
    List<String> exitFlagsList = new LinkedList<String>();
    Map<String, String> xPathsMap = new HashMap<String, String>();
    Map<String, String> multiXPathsMap = new HashMap<String, String>();
    Map<String, String> namespacesMap = new HashMap<String, String>();
    String[][] handlers = null;
    private static final String EXIT_ON_ERROR_ATTRIBUTE = "ExitOnError";

    @Override
    public void endDocument() {
        if (!this.handlerList.isEmpty() && !this.exitFlagsList.isEmpty()) {
            this.handlers = new String[2][];
            this.handlers[0] = this.handlerList.toArray(new String[0]);
            this.handlers[1] = this.exitFlagsList.toArray(new String[0]);
            this.config.put("Handlers", this.handlers);
        }
        if (!this.xPathsMap.isEmpty()) {
            this.config.put("xpathsMap", this.xPathsMap);
        }
        if (!this.multiXPathsMap.isEmpty()) {
            this.config.put("multiXpathsMap", this.multiXPathsMap);
        }
        if (!this.namespacesMap.isEmpty()) {
            this.config.put("namespacesMap", this.namespacesMap);
        }
    }

    @Override
    public void startElement(String uri, String name, String rawname, Attributes atts) {
        this.current = rawname;
        this.attributes = atts;
        this.data = new StringBuffer();
        if (this.current.equalsIgnoreCase("SystemProperty")) {
            String nameAtt = this.attributes.getValue("name");
            String defaultAtt = this.attributes.getValue("default");
            if (nameAtt.equalsIgnoreCase("service.listen.host")) {
                if (defaultAtt == null) {
                    defaultAtt = "localhost";
                }
                this.config.put("HOST", defaultAtt);
            }
            if (nameAtt.equalsIgnoreCase("service.listen.port")) {
                this.config.put("PORT", defaultAtt);
            }
        }
    }

    @Override
    public void endElement(String uri, String name, String rawname) {
        if (this.data != null && this.data.toString().trim().length() > 0) {
            if (rawname.equals("Handler") && this.attributes != null) {
                this.handlerList.add(this.data.toString().trim());
                this.exitFlagsList.add(this.attributes.getValue(EXIT_ON_ERROR_ATTRIBUTE));
            } else if (rawname.equals("MetaData") && this.attributes != null) {
                this.xPathsMap.put(this.attributes.getValue("key"), this.data.toString().trim());
            } else if (rawname.equals("MultiData") && this.attributes != null) {
                this.multiXPathsMap.put(this.attributes.getValue("key"), this.data.toString().trim());
            } else if (rawname.equals("NameSpace") && this.attributes != null) {
                this.namespacesMap.put(this.attributes.getValue("key"), this.data.toString().trim());
            } else {
                this.config.put(rawname, this.data.toString().trim());
            }
        }
        this.data = new StringBuffer();
        this.attributes = null;
    }

    @Override
    public void characters(char[] ch, int start, int end) {
        String elementValue = new String(ch, start, end);
        this.data.append(elementValue);
    }

    public Properties getConfig() {
        return this.config;
    }
}

