/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import uk.gov.hmrc.aspire.lts.LTSSystemException;
import uk.gov.hmrc.aspire.lts.utils.XMLParser;

public class ConfigReader {
    private String configFilename;
    private static Map<String, Properties> configStore = Collections.synchronizedMap(new HashMap());

    public ConfigReader(String pConfigFile) {
        if (pConfigFile == null) {
            throw new LTSSystemException("No config file specified...");
        }
        this.configFilename = pConfigFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getConfig() throws Exception {
        Properties props = null;
        Map<String, Properties> map = configStore;
        synchronized (map) {
            props = configStore.get(this.configFilename);
            if (props != null) {
                return props;
            }
        }
        props = XMLParser.getConfig(this.configFilename);
        map = configStore;
        synchronized (map) {
            configStore.put(this.configFilename, props);
        }
        return props;
    }
}

