/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.utils;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    public static final String XSD_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss:SSS";
    public static final String XSD_DATE_FORMAT = "yyyy-MM-dd";
    private static final String GATEWAY_TIMESTAMP_1 = "yyyy-MM-dd'T'HH:mm:ss:SSS";
    private static final String GATEWAY_TIMESTAMP_2 = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final String GATEWAY_TIMESTAMP_3 = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String GATEWAY_TIMESTAMP_4 = "yyyy-MM-dd HH:mm:ss:SSS";
    private static final String GATEWAY_TIMESTAMP_5 = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String GATEWAY_TIMESTAMP_6 = "yyyy-MM-dd HH:mm:ss";

    public static final Date getEndOfTaxYearDate(Date date) {
        Calendar taxDate = Calendar.getInstance();
        taxDate.setTime(date);
        if (taxDate.get(2) > 4 || taxDate.get(2) == 4 && taxDate.get(5) > 5) {
            taxDate.add(1, 1);
        }
        Calendar endOfThisTaxYear = Calendar.getInstance();
        endOfThisTaxYear.set(5, 5);
        endOfThisTaxYear.set(2, 3);
        endOfThisTaxYear.set(1, taxDate.get(1));
        return endOfThisTaxYear.getTime();
    }

    public static final int getEndOfTaxYear(Date date) {
        Calendar taxDate = Calendar.getInstance();
        taxDate.setTime(date);
        if (taxDate.get(2) > 4 || taxDate.get(2) == 4 && taxDate.get(5) > 5) {
            taxDate.add(1, 1);
        }
        Calendar endOfThisTaxYear = Calendar.getInstance();
        endOfThisTaxYear.set(5, 5);
        endOfThisTaxYear.set(2, 3);
        endOfThisTaxYear.set(1, taxDate.get(1));
        return endOfThisTaxYear.get(1);
    }

    public static final Calendar getSpecifiedCalendar(int day, int month, int year) {
        Calendar messageReceivedCal = Calendar.getInstance();
        messageReceivedCal.set(5, day);
        messageReceivedCal.set(2, month);
        messageReceivedCal.set(1, year);
        return messageReceivedCal;
    }

    public static final Date getSpecifiedDate(int day, int month, int year) {
        Calendar cal = DateUtils.getSpecifiedCalendar(day, month, year);
        return cal.getTime();
    }

    public static final String formatDate(String dateFormat, Date dateToBeFormatted) throws DateUtilsException {
        if (dateFormat == null || dateToBeFormatted == null) {
            throw new DateUtilsException("The values supplied are incorrect [dateFormat = " + dateFormat + "], [dateToBeFormatted = " + String.valueOf(dateToBeFormatted) + "]");
        }
        DateFormat df = DateUtils.getFormatter(dateFormat);
        return df.format(dateToBeFormatted);
    }

    private static final DateFormat getFormatter(String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df;
    }

    public static final String formatGatewayTimestamp(Date dateToBeFormatted) throws DateUtilsException {
        return DateUtils.formatDate("yyyy-MM-dd'T'HH:mm:ss:SSS", dateToBeFormatted);
    }

    private static boolean validateLength(String date, String format) {
        boolean failedParse = false;
        StringBuffer strippedFormat = new StringBuffer(format);
        int position = 0;
        while ((position = strippedFormat.indexOf("'")) != -1) {
            strippedFormat.deleteCharAt(position);
        }
        if (date.length() < strippedFormat.length()) {
            return false;
        }
        if (date.length() > strippedFormat.length()) {
            return false;
        }
        return !failedParse;
    }

    public static Date parseDate(String source, String format) throws DateUtilsException {
        return DateUtils.parseDate(source, format, false);
    }

    public static Date parseDate(String source, String format, boolean lenient) throws DateUtilsException {
        if (source == null || source.trim().length() == 0 || format == null || format.trim().length() == 0) {
            throw new DateUtilsException("Source or format string was null.  Date to be formated : " + source + ".  Format to use " + format);
        }
        if (!lenient && !DateUtils.validateLength(source, format)) {
            throw new DateUtilsException("Date string could not be parsed.  Date: " + source + ", Format: " + format);
        }
        try {
            DateFormat sdf = DateUtils.getFormatter(format);
            sdf.setLenient(lenient);
            return sdf.parse(source);
        }
        catch (ParseException e) {
            throw new DateUtilsException("Date string could not be parsed.  Date: " + source + ", Format: " + format);
        }
    }

    public static Date parseGatewayDate(String dateTime) throws DateUtilsException {
        String[] dateFormats = new String[]{"yyyy-MM-dd'T'HH:mm:ss:SSS", GATEWAY_TIMESTAMP_2, GATEWAY_TIMESTAMP_3, GATEWAY_TIMESTAMP_4, GATEWAY_TIMESTAMP_5, GATEWAY_TIMESTAMP_6};
        Date date = null;
        for (int i = 0; i < dateFormats.length; ++i) {
            try {
                date = DateUtils.parseDate(dateTime, dateFormats[i], false);
                continue;
            }
            catch (DateUtilsException dateUtilsException) {
                // empty catch block
            }
        }
        if (date == null) {
            throw new DateUtilsException("Date string to be formated was null");
        }
        return date;
    }

    public static java.sql.Date createSQLDate(Date date) {
        if (date == null) {
            return null;
        }
        return new java.sql.Date(date.getTime());
    }

    public static Timestamp createTimeStamp(Date date) {
        if (date == null) {
            return null;
        }
        return new Timestamp(date.getTime());
    }

    public static class DateUtilsException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public DateUtilsException(String message) {
            super(message, null);
        }
    }
}

