/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;

public class OMElementUtils {
    private static OMFactory factory = OMAbstractFactory.getOMFactory();
    private static OMNamespace errorRespNamespace = factory.createOMNamespace("http://www.govtalk.gov.uk/CM/errorresponse", "");

    public static OMNode getOMNode(String xmlString) {
        ByteArrayInputStream is = new ByteArrayInputStream(xmlString.getBytes());
        XMLStreamReader parser = null;
        try {
            parser = XMLInputFactory.newInstance().createXMLStreamReader(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        return builder.getDocumentElement();
    }

    public static OMNode getOMNode(InputStream xml) {
        XMLStreamReader parser = null;
        try {
            parser = XMLInputFactory.newInstance().createXMLStreamReader(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        return builder.getDocumentElement();
    }

    public static OMNode getErrorNode(String number, String type, String text, String location) {
        OMElement error = factory.createOMElement("Error", errorRespNamespace);
        OMElement raisedBy = factory.createOMElement("RaisedBy", errorRespNamespace, (OMContainer)error);
        raisedBy.addChild((OMNode)factory.createOMText("ChRIS"));
        OMElement numberNode = factory.createOMElement("Number", errorRespNamespace, (OMContainer)error);
        numberNode.addChild((OMNode)factory.createOMText(number));
        OMElement typeNode = factory.createOMElement("Type", errorRespNamespace, (OMContainer)error);
        typeNode.addChild((OMNode)factory.createOMText(type));
        OMElement textNode = factory.createOMElement("Text", errorRespNamespace, (OMContainer)error);
        textNode.addChild((OMNode)factory.createOMText(text));
        OMElement locationNode = factory.createOMElement("Location", errorRespNamespace, (OMContainer)error);
        locationNode.addChild((OMNode)factory.createOMText(location));
        return error;
    }
}

