/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.aspire.lts.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import uk.gov.hmrc.aspire.lts.utils.DateUtils;

public class Utils {
    public static Throwable getRootCause(Throwable parent) {
        Throwable cause = parent;
        while ((parent = parent.getCause()) != null) {
            cause = parent;
        }
        return cause;
    }

    public static String toString(Object o) {
        Field[] fields;
        StringBuffer buffer = new StringBuffer();
        Class<?> clazz = o.getClass();
        buffer.append("\n/** " + clazz.getName().replaceAll(".*\\.", "") + " **/\n");
        for (Field field : fields = clazz.getDeclaredFields()) {
            try {
                field.setAccessible(true);
                if (Character.isUpperCase(field.getName().charAt(0))) continue;
                buffer.append(field.getName());
                buffer.append('=');
                buffer.append(field.get(o));
                buffer.append('\n');
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObject(Object o) {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            File f = new File(o.getClass().getName().replaceAll("\\.class", "") + ".dat");
            Vector list = null;
            if (f.exists()) {
                in = new FileInputStream(f);
                ObjectInputStream dec = new ObjectInputStream(in);
                list = (Vector)dec.readObject();
                for (int i = 0; i < list.size(); ++i) {
                    Object o2 = list.get(i);
                    if (o2.hashCode() != o.hashCode()) continue;
                    list.remove(i);
                    break;
                }
                list.add(o);
            } else {
                list = new Vector();
                list.add(o);
            }
            out = new FileOutputStream(f);
            ObjectOutputStream enc = new ObjectOutputStream(out);
            enc.writeObject(list);
            enc.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readObject(Object o) {
        File f = new File(o.getClass().getName().replaceAll("\\.class", "") + ".dat");
        if (!f.exists()) {
            return null;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(f);
            ObjectInputStream dec = new ObjectInputStream(in);
            Vector list = (Vector)dec.readObject();
            for (int i = 0; i < list.size(); ++i) {
                Object o2 = list.get(i);
                if (o2.hashCode() != o.hashCode()) continue;
                Object e = o2;
                return e;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static Object loadBeanDataFromPropertiesFile(Object o) {
        return Utils.loadBeanDataFromPropertiesFile2(o, System.getProperty("DataFileName"));
    }

    public static Object loadBeanDataFromPropertiesFile2(Object o, String fileName) {
        try {
            Hashtable config = Utils.getProperties(fileName);
            Class<?> clazz = o.getClass();
            Iterator iterator = config.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry en;
                Map.Entry entry = en = iterator.next();
                Field field = null;
                try {
                    field = clazz.getDeclaredField((String)entry.getKey());
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
                if (field == null) continue;
                field.setAccessible(true);
                String value = entry.getValue().toString();
                if (value.trim().length() == 0) {
                    value = null;
                }
                if (value == null) continue;
                if (field.getType().isAssignableFrom(Date.class)) {
                    String newValue = Utils.replaceDatesPlaceholder(value);
                    try {
                        field.set(o, DateUtils.parseDate(newValue, "yyyy-MM-dd"));
                    }
                    catch (Exception e) {
                        field.set(o, DateUtils.parseDate(newValue, "yyyy-MM"));
                    }
                    continue;
                }
                if (field.getType().isAssignableFrom(BigDecimal.class)) {
                    field.set(o, new BigDecimal(value));
                    continue;
                }
                if (field.getType().isAssignableFrom(Long.TYPE)) {
                    field.set(o, Long.valueOf(value));
                    continue;
                }
                if (field.getType().isAssignableFrom(Boolean.TYPE)) {
                    field.set(o, Boolean.valueOf(value));
                    continue;
                }
                field.set(o, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return o;
    }

    public static Hashtable getProperties(String file) {
        try {
            Date d = new Date();
            FileInputStream is = new FileInputStream(file);
            Properties config = new Properties();
            config.load(is);
            ((InputStream)is).close();
            for (Map.Entry<Object, Object> entry : config.entrySet()) {
                String v = entry.getValue().toString();
                entry.setValue(Utils.replaceDatesPlaceholder(v, d));
            }
            return config;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String replaceDatesPlaceholder(String v) {
        return Utils.replaceDatesPlaceholder(v, new Date());
    }

    public static String replaceDatesPlaceholder(String v, Date d) {
        try {
            Date newDate = d;
            if (newDate == null) {
                newDate = new Date();
            }
            String newV = v.replaceAll(Utils.asPlaceholder("tomorrow"), DateUtils.formatDate("yyyy-MM-dd", Utils.addDays(newDate, 1)));
            newV = newV.replaceAll(Utils.asPlaceholder("timestamp"), DateUtils.formatDate("yyyy-MM-dd'T'hh:mm:ss", newDate));
            newV = newV.replaceAll(Utils.asPlaceholder("today"), DateUtils.formatDate("yyyy-MM-dd", newDate));
            newV = newV.replaceAll(Utils.asPlaceholder("today.short"), DateUtils.formatDate("yyyy-MM", newDate));
            newV = newV.replaceAll(Utils.asPlaceholder("yesterday"), DateUtils.formatDate("yyyy-MM-dd", Utils.addDays(newDate, -1)));
            newV = newV.replaceAll(Utils.asPlaceholder("yesterday.short"), DateUtils.formatDate("yyyy-MM", Utils.addDays(newDate, -1)));
            newV = newV.replaceAll(Utils.asPlaceholder("endOfMonth"), DateUtils.formatDate("yyyy-MM-dd", Utils.setLastDayMonth(newDate)));
            newV = newV.replaceAll(Utils.asPlaceholder("beginOfMonth"), DateUtils.formatDate("yyyy-MM-dd", Utils.setFirstDayMonth(newDate)));
            newV = newV.replaceAll(Utils.asPlaceholder("lastMonth.short"), DateUtils.formatDate("yyyy-MM", Utils.setFirstDayMonth(newDate, -1)));
            newV = newV.replaceAll(Utils.asPlaceholder("endOfLastMonth"), DateUtils.formatDate("yyyy-MM-dd", Utils.setLastDayMonth(newDate, 0)));
            newV = newV.replaceAll(Utils.asPlaceholder("beginOfLastMonth"), DateUtils.formatDate("yyyy-MM-dd", Utils.setFirstDayMonth(newDate, -1)));
            newV = newV.replaceAll(Utils.asPlaceholder("nextMonth"), DateUtils.formatDate("yyyy-MM-dd", Utils.setNextMonth(newDate, 1)));
            newV = newV.replaceAll(Utils.asPlaceholder("lastMonth"), DateUtils.formatDate("yyyy-MM-dd", Utils.setNextMonth(newDate, -1)));
            return newV;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String replaceStringRegion(String original, String startMarker, String endMarker, String replacement, boolean startInclusive, boolean endInclusive) {
        StringBuilder result = new StringBuilder();
        int replacementStartIndex = original.indexOf(startMarker);
        int replacementEndIndex = original.indexOf(endMarker);
        if (replacementStartIndex > -1 && replacementEndIndex > -1) {
            if (!startInclusive) {
                replacementStartIndex += startMarker.length();
            }
            if (endInclusive) {
                replacementEndIndex += endMarker.length();
            }
            result.append(original.substring(0, replacementStartIndex));
            result.append(replacement);
            result.append(original.substring(replacementEndIndex));
        }
        return result.toString();
    }

    public static String replaceStringRegion(String original, String startMarker, String endMarker, String replacement) {
        return Utils.replaceStringRegion(original, startMarker, endMarker, replacement, false, false);
    }

    public static String asPlaceholder(String key) {
        return "\\$\\{" + key + "\\}";
    }

    public static Date resetTime(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        c.set(10, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date addDays(Date d, int days) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        c.add(5, days);
        return c.getTime();
    }

    public static Date setFirstDayMonth(Date d) {
        return Utils.setFirstDayMonth(d, 0);
    }

    public static Date setFirstDayMonth(Date d, int months) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        c.set(5, 1);
        c.add(2, months);
        return c.getTime();
    }

    public static Date setLastDayMonth(Date d) {
        return Utils.setLastDayMonth(d, 1);
    }

    public static Date setLastDayMonth(Date d, int months) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        c.set(5, 1);
        c.add(2, months);
        c.set(5, -1);
        return c.getTime();
    }

    public static Date setNextMonth(Date d, int months) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        c.add(2, months);
        return c.getTime();
    }

    public static boolean isBetweenDates(Date di, Date df, Date d) {
        return di.compareTo(d) <= 0 && df.compareTo(d) >= 0;
    }
}

